#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>

/*
 * BBeB dictionary tester
 * Version 0.1
 * 2011-04-07
 *
 * Copyright (c) 2011 Igor Skochinsky
 *
 * This software is provided 'as-is', without any express or implied
 * warranty. In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 *    1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 *
 *    2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 *    3. This notice may not be removed or altered from any source
 *    distribution.
*/

// compile: arm-none-linux-gnueabi-gcc -O2 dicttest.c -o dicttest FskBBeBDictionary.so -Wl,--allow-shlib-undefined
// run: LD_LIBRARY_PATH=/opt/sony/ebook/application /mnt/sd/dict/dicttest /path/to/library.mbf

typedef struct _SearchResultDataRecord
{
  int itemNo;         // dict item number
  char keyAtr;
  char f5[3];         // alignment padding
  uint16_t *pwszText; // utf-16 string
} SearchResultDataRecord;

// functions from FskBBeBDictionary
extern int  OpenLibraryFile(const char *filename);
extern int  OpenDicFile(int num);
extern void CloseDicFile();
extern void CloseDictionaries();
// records array should be big enough (100 items?)
// term is in UTF-8
// returns number of filled records
extern int  SearchForward(SearchResultDataRecord *records, unsigned char *term)
// get content of a dictionary article, with tags
extern int  GetContent(unsigned char **ppBuf, int itemNo);
extern int  GetCurrentDictionaryProperty(int dicno);

int main(int argc, char *argv[])
{
  if ( argc < 2 )
  {
    printf("Usage: dicttest LIBRARY.MBF\n");
    return 1;
  }
  int nDicts = OpenLibraryFile(argv[1]);
  printf("OpenLibraryFile('%s'): %d\n", argv[1], nDicts);
  int i;
  for ( i = 0; i < nDicts; i++ )
  {
    int ok = OpenDicFile(i);
    printf("OpenDicFile(%d): %d\n", i, ok);
    unsigned char *pdata;
    int datalen = GetContent(&pdata, 1);
    printf("GetContent(1): %d\n", datalen);
  }
  CloseDictionaries();
  return 0;
}
