Vala for DR v1
==============
Iñigo Serna <inigoserna@gmail.com>
Last update: Sat Apr  2 13:34:35 2011


Executive summary
-----------------
Vala for DR is a development package to allow writing fully integrated
applications for iRex DR devices in Vala, a new high level language [1].


Historical note
---------------
During some months I've been maturing the idea to extend DR core programs
without C, using an easier and faster (to write code in) language. So I started
learning and playing with lua, waiting for LuaJIT [2] to be available for ARM
processors. This would allow us to use the impressive FFI support in LuaJIT to
call DR libraries from lua code without writing bindings. But ARM processors
are not supported yet...

And I was musing this mood when I unexpectedly read a MobileReader thread
I haven't seen before [3].
All credit for exploring this idea is for ross therefore.


Vala
----
Vala is a new language created in the GNOME desktop world.
People say its syntaxis is similar to C# or Java, but I can't say it myself
because I don't know much about both of them.

The main feature of Vala is that it compiles from .vala sources to C code,
which is then compiled and linked to generate the final machine code.
Note the whole compilation from .vala sources to binary program can be
performed in just one step too.

Though more low level than lua or python, it's easier and faster to code
than C, and offers much more faster execution speed than scripting languages
(but not as fast as plain C).

Vala also comes with lot of "bindings" for many popular libraries.
And it's easy to write bindings for "our" DR libraries (take a look at
"liberipc.vapi" file).

But the main advantage I see for DR development is that we could write modules
in Vala easily, and then use these C sources to extend original firmware.


Current status of Vala for DR development
-----------------------------------------
I've taken what ross provided and updated to support modern versions of Vala.
I've also fixed and improved the irex.vala and liberipc.vapi files adding
some new functions. More will come as needed.

Note that Vala is not perfect, it's quite new and in continue development.
I've also found some issues: vala is so new that it sometimes depends on the
last versions of glib to do some tasks, and this causes problems with the "old"
libraries coming with DRs.

Anyway, I've been able to translate and improve some previously lua-written
program (sysinfo and icons) into vala without prior knowledgement of Vala or
C# in ~10 hours of work each.
Most of this time was spent reading Vala documentation, fixing the Vala
environment (irex.vala, liberipc.vapi) and fighting against some
imcompatibilities between vala v0.11.7 and DR older libraries.

I'm pretty satisfied with the results, the programs look fast, robust,
integrates well with DR and even don't depend on external runtime or
libraries.

But what excited me most is the now opened possibility to write enhancements
to core DR programs using a higher level language than C, so we could test new
ideas faster and with less effort.


Instructions to use Vala for DR
-------------------------------
Steps:
- You need a running DR development environment
- Download, build and install Vala
  . download v0.11.7 from [1]
  . build and install Vala using devel machine compiler (i.e, gcc, not arm-poky-linux-gnueabi-gcc)
- Look at sysinfo or icons sources as examples:
  . all Vala needed files are in the "irex" directory
  . set the cross-compiling environment:
    $ source /usr/local/poky/eabi-glibc/arm/environment-setup
  . run "make"
    $ make
- That's it
  . there could be some warnings, they usually don't matter



[1] http://live.gnome.org/Vala
[2] http://luajit.org/
[3] http://www.mobileread.com/forums/showthread.php?t=39212


Kind regards,
Iñigo Serna
