using GLib;


namespace MyIrexUtils {
    [CCode (cname = "struct tm", cheader_filename = "time.h", has_type_id = false)]
    public struct tm {
        [CCode (cname = "tm_sec")]
        public int second;
        [CCode (cname = "tm_min")]
        public int minute;
        [CCode (cname = "tm_hour")]
        public int hour;
        [CCode (cname = "tm_mday")]
        public int day;
        [CCode (cname = "tm_mon")]
        public int month;
        [CCode (cname = "tm_year")]
        public int year;
        [CCode (cname = "tm_wday")]
        public int weekday;
        [CCode (cname = "tm_yday")]
        public int day_of_year;
        [CCode (cname = "tm_isdst")]
        public int isdst;
    }


    [CCode (cheader_filename = "time.h", cname = "gmtime_r")]
    static void gmtime_r (ref time_t time, out tm result);
    [CCode (cheader_filename = "time.h", cname = "localtime_r")]
    static void localtime_r (ref time_t time, out tm result);

    [CCode (cheader_filename = "time.h", cname = "strftime")]
    public size_t strftime (char[] s, string format, ref tm timeptr);

    public tm now2tm() {
        var secs = TimeVal().tv_sec;
        tm now;
        localtime_r(ref secs, out now);
        return now;
    }

    public string tm2strftime(ref tm timeptr, string format) {
        var datestr = new char[256];
        strftime(datestr, format, ref timeptr);
        return (string) datestr;
    }

    public string now2strftime(string format) {
        tm now = now2tm();
        return tm2strftime(ref now, format);
    }
}
