#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai
from __future__ import (unicode_literals, division, absolute_import,
                        print_function)

__license__   = 'GPL v3'
__copyright__ = '2011, Kovid Goyal <kovid@kovidgoyal.net>'
__docformat__ = 'restructuredtext en'

from PyQt4.Qt import QWidget, QVBoxLayout, QLabel, QLineEdit, \
                     QGroupBox, QGridLayout
from calibre.utils.config import JSONConfig

STORE_NAME = 'Shortcuts'
KEY_MARK_SHORTCUT = 'markShortcut'
KEY_UNMARK_SHORTCUT = 'unmarkShortcut'
KEY_SHOW_SHORTCUT = 'showShortcut'
KEY_CLEAR_SHORTCUT = 'clearShortcut'
DEFAULT_STORE_VALUES = {
    KEY_MARK_SHORTCUT: '',
    KEY_UNMARK_SHORTCUT: '',
    KEY_SHOW_SHORTCUT: '',
    KEY_CLEAR_SHORTCUT: ''
}

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig('plugins/Temp Marker')

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        layout = QVBoxLayout(self)
        self.setLayout(layout)

        group_box = QGroupBox('Keyboard shortcuts:', self)
        layout.addWidget(group_box)
        group_box_layout = QGridLayout()
        group_box.setLayout(group_box_layout)

        row = 0
        c = plugin_prefs[STORE_NAME]
        for key, text in [(KEY_MARK_SHORTCUT, 'Mark selected'),
                           (KEY_UNMARK_SHORTCUT, 'Unmark selected'),
                           (KEY_SHOW_SHORTCUT, 'Show marked'),
                           (KEY_CLEAR_SHORTCUT, 'Clear all marked')]:
            label = QLabel(text+':', self)
            lineEdit = QLineEdit(c[key], self)
            setattr(self, '_'+key, lineEdit)
            label.setBuddy(lineEdit)
            group_box_layout.addWidget(label, row, 0, 1, 1)
            group_box_layout.addWidget(lineEdit, row, 1, 1, 1)
            row += 1

    def save_settings(self):
        # Invoked when user clicks ok in preferences dialog. Persist our configuration to JSON file.
        new_prefs = {}
        for key in (KEY_MARK_SHORTCUT, KEY_UNMARK_SHORTCUT,
                    KEY_SHOW_SHORTCUT, KEY_CLEAR_SHORTCUT):
            new_prefs[key] = unicode(getattr(self, '_'+key).text()).strip()

        plugin_prefs[STORE_NAME] = new_prefs
