using GLib;
using Posix;

[CCode (cheader_filename = "liberipc/eripc.h")]
namespace liberipc {

    [CCode (cname = "eripc_event_info_t", cprefix = "ERIPC_ERROR_")]
    public enum Error {
        SUCCESS,
        INVALID,
        OOM,
        GENERIC,
        TIMEOUT,
    }

    [CCode (cprefix = "ERIPC_TYPE_")]
    public enum Type {
        INVALID,
        BOOL,
        BYTE,
        INT,
        UINT,
        DOUBLE,
        STRING,
        DATA
    }

    [CCode (cprefix = "ERIPC_BUS_")]
    public enum Bus {
        IRRELEVANT,
        SYSTEM,
        SESSION,
        BOTH
    }

    [CCode (cprefix = "ERIPC_EVENT_")]
    public enum Event {
        NONE,
        MESSAGE,
        SIGNAL,
        MESSAGE_OR_SIGNAL,
        REPLY,
        ERROR,
        REPLY_OR_ERROR,
    }

    public struct ArgString {
        public char *s;
    }

    [CCode (cname = "eripc_arg_t")]
    public struct Arg {
        public int type;
        public int data_len;
        public ArgString value;
    }

    [Compact]
    [CCode (cname = "eripc_event_info_t")]
    public class EventInfo {
        string service;
        string path;
        string iface;
        string name;
        Event  event_type;
        Bus    bus_type;
        public string message_id;
        public string error;
        public Arg *args;
        public string dbus_message;
    }

    [CCode (cname = "eripc_handler_t", has_target = false)]
    public static delegate void Handler(Context context, EventInfo info, void *user_data);

    [Compact]
    [CCode (cname = "eripc_context_t", cprefix = "eripc_", free_function="")]
    public class Context {
        [CCode (cname = "eripc_init")]
        public Context (string program_name, string program_version, MainContext *ctx);

        public Error set_signal_handler(Handler *handler, void *user_data, Bus bus_type, string source, string signal_name, int *handler_id);
        public Error set_message_handler(Handler *handler, void *user_data, Bus bus_type, string source, string message_name, int *handler_id);
        public Error unset_handler(int handler_id);

        public Error send_varargs(Handler *reply_handler, void *user_data, Bus bus_type, string destination, string message_name, Type arg_type, ...);
        public Error send_varargs_and_wait(EventInfo **info, Bus bus_type, string destination, string message_name, Type arg_type, ...);
        public Error send_signal_varargs(Bus bus_type, string signal_path, string signal_interface, string signal_name, Type arg_type, ...);

        public Error reply_bool(string message_id, bool val);
        public Error reply_varargs(string message_id, Type arg_type, ...);
    }

}
