/**********************************************************************************************
    Copyright (C) 2010 Stephan Olbrich reader42@gmx.de

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

**********************************************************************************************/
//
// zeit_downloader main.cpp
//

#include <inkview.h>
#include <stdio.h>
#include <string>
#include <cstdlib>
#include <curl/curl.h>

#ifdef HOST_X86
#define BASE "/usr/local/pocketbook"
#define ZEIT "/tmp/"
#else
#define BASE ""
#define ZEIT BASE "/mnt/ext2/zeit/"
#endif

#define GAMES BASE "/mnt/ext1/games/"
#define LOGFILE GAMES "zeit_downloader.log"

#define ZEIT_TMP ZEIT "tmp.epub"

FILE * LogFile=0;

static int writer(char *data, size_t size, size_t nmemb, std::string *writerData)
{
  if (writerData == NULL)
    return 0;
    
  writerData->append(data, size*nmemb);
//  fprintf(LogFile, "Data!\n");
  
  return size * nmemb;
}

static int header(char *data, size_t size, size_t nmemb, std::string *writerData)
{
  if (writerData == NULL)
    return 0;
  std::string tmp;
  uint pos1, pos2;
  tmp.append(data, size*nmemb);
//  fprintf(LogFile, tmp.c_str());
  
  pos1 = tmp.find("filename");
  if (pos1!=std::string::npos) {
    pos2 = tmp.find("epub", pos1);
    writerData->append(tmp.substr(pos1+10, pos2-(pos1+10)+4));
//    fprintf(LogFile, writerData->c_str());
//    fprintf(LogFile, "\n");
  }
  return size * nmemb;
}

void curl_code_check(CURL *curl, CURLcode code, const char * error)
{
  if (code != CURLE_OK) {
    fprintf(LogFile, error);
    curl_easy_cleanup(curl);
    exit(1);
  }
  return;
}

int downloadZeit() {
  CURL *curl;
  CURLcode code;
  std::string buffer;
  std::string fname;
  
  // init curl
//   curl_global_init(CURL_GLOBAL_DEFAULT); // inkview should call this
  curl = curl_easy_init();
  if (!curl){
    fprintf(LogFile, "CURL-Error!\n");
    curl_easy_cleanup(curl);
    return -1;
  }
  //  code = curl_easy_setopt(curl, CURLOPT_VERBOSE, 1);
  code = curl_easy_setopt(curl, CURLOPT_URL, "https://premium.zeit.de/abovorteile/cgi-bin/_er_member/p4z.fpl?ER_Do=getUserData&ER_NextTemplate=login_ok");
  curl_code_check(curl, code, "URL Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_USERPWD, "username:passwd"); 
  curl_code_check(curl, code, "PWD Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_HTTPAUTH, CURLAUTH_ANY);
  curl_code_check(curl, code, "Auth Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0); // Verify does not work on pocketbook
  curl_code_check(curl, code, "CA Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, writer);
  curl_code_check(curl, code, "Write function Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_WRITEDATA, &buffer);
  curl_code_check(curl, code, "Buffer Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1L); // Follow redirects
  curl_code_check(curl, code, "Redirect Error!\n");
  
  code = curl_easy_perform(curl); // and action!
  curl_code_check(curl, code, "Download Error!\n");
  
  // find new link
  size_t pos1, pos2;
  pos1 = buffer.find("/abovorteile/cgi-bin/");
  pos2 = buffer.find(">", pos1);
  std::string new_url = "https://premium.zeit.de";
  new_url.append(buffer.substr(pos1, pos2-pos1-1));
  buffer.clear(); // clear buffer for next site
  
  fprintf(LogFile, new_url.c_str());
  fprintf(LogFile, "\n");
  code = curl_easy_setopt(curl, CURLOPT_URL, new_url.c_str());
  curl_code_check(curl, code, "URL Error!\n");
  
  code = curl_easy_perform(curl); // and action!
  curl_code_check(curl, code, "Download Error!\n");
  
  // find new link
  pos1 = buffer.find("http://contentserver.hgv-online.de");
  pos2 = buffer.find(">", pos1);
  new_url.clear();
  new_url = buffer.substr(pos1, pos2-pos1-1);
  
  code = curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, NULL); // reset callback to default handler
  curl_code_check(curl, code, "Write function Error!\n");
  
  FILE * epub = 0;
  epub = fopen(ZEIT_TMP, "w");
  
  code = curl_easy_setopt(curl, CURLOPT_WRITEDATA, epub); // set file for default handler
  curl_code_check(curl, code, "File Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_URL, new_url.c_str());
  curl_code_check(curl, code, "URL Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_HEADERFUNCTION, header); // collback for header
  curl_code_check(curl, code, "Header function Error!\n");
  
  code = curl_easy_setopt(curl, CURLOPT_WRITEHEADER, &fname); // buffer for filename
  curl_code_check(curl, code, "Header buffer Error!\n");
  
  code = curl_easy_perform(curl); // and action!
  curl_code_check(curl, code, "Download Error!\n");
  
  fclose(epub);
  fname.insert(0, ZEIT);
  rename(ZEIT_TMP, fname.c_str());
  
  fprintf(LogFile, fname.c_str());
  
//   curl_easy_cleanup(curl); // inkview probably calls this
  return 0;
}

char* defaultNetConnection()
{
  iconfig * config;
  config = OpenConfig(NETWORKCONFIGFILE, NULL);
  return ReadString(config, "preferred", "default");
}

int NetworkConnect()
{
  if (!((QueryNetwork() & NET_WIFIREADY) || (QueryNetwork() & NET_BTREADY)))
  {
    fprintf(LogFile, "Connecting ... (%d)\n", QueryNetwork());
    return NetConnect(defaultNetConnection());
  }
  return 0;
}

int NetworkDisconnect()
{
  return NetDisconnect();
}

int main_handler(int type, int par1, int par2)
{
  fprintf(LogFile, "main_handler(), type: %d\n", type);
  if ( type == EVT_INIT) {
    NetworkConnect();
    downloadZeit();
    NetworkDisconnect();
    CloseApp();
  }
  return 0;
}

int main(int argc, char **argv) {
  LogFile = fopen(LOGFILE, "w");
  setbuf(LogFile, 0); // set buffer to 0 -> all data is written directly, so nothing is lost in case of a segfault
  fprintf(LogFile, "Start!\n");
  
  InkViewMain(main_handler);
  
  fclose(LogFile);
  return 0;
}
