#!/bin/sh
#
# Idea of Igorsk, script by Corwin

PATH="/usr/local/bin:/usr/bin:/sbin:/bin:/usr/bin/X11:/usr/games:/usr/local/sony/bin:/usr/sbin"
LD_LIBRARY_PATH="/opt/sony/ebook/application:/lib:/usr/lib:/usr/local/sony/lib:/opt/sony/ebook/lib"
export PATH LD_LIBRARY_PATH

# Intitial variables
# Max Image Size in bytes 7340032 - 100bytes
OPT_IMG_SIZE=7339932

# Temp Working Filesystem
W_FS=/Data
W_DIR=/Data/self_upgrade
W_LOG=/Data/tmp/make_fs.log
RESFILE=/Data/tmp/result.log
M_CARD=`cat /tmp/cardroot`

# Binaries
stat_fs=/tmp/bin/stat_fs
date=/bin/date
mkdir=/bin/mkdir
rm=/bin/rm
tar=/bin/tar
mkcramfs=/usr/bin/mkcramfs
mcopy=/tmp/mcopy
#mcopy=/usr/bin/mcopy
chmod=/bin/chmod
du=/usr/bin/du
cut=/usr/bin/cut
nblsdm=/usr/local/sony/bin/nblsdm
umount=/bin/umount
mtdmount=/usr/local/sony/bin/mtdmount

echo -n "Begin upgrade -> " > $W_LOG
$date >> $W_LOG


$chmod -R ugo+rx $mcopy >> $W_LOG 2>&1
# Copying stat_fs
$mkdir -p /tmp/bin >> $W_LOG 2>&1
echo "Copying helper binaries" >> $W_LOG
$mcopy -pnsv $M_CARD/bin/* /tmp/bin/ >> $W_LOG 2>&1
$chmod -R ugo+rx /tmp/bin/* >> $W_LOG 2>&1

if [ ! -x $stat_fs ]; then
  echo "No stat_fs found!" >> $W_LOG
  echo -n "1 stat_fs not found." > $RESFILE
  exit 1;
fi

if [ -d $W_DIR ]; then
  echo "$W_DIR found! Cleaning ..." >> $W_LOG
  $rm -rf $W_DIR
fi

$mkdir -p $W_DIR/new_opt
echo "$W_DIR Created!" >> $W_LOG

# Checking avaliable space
W_A_SIZE=`$stat_fs -a $W_FS`
OPT_U_SIZE=`$stat_fs -u /opt`

# approximate needed space
N_SPACE=`expr $OPT_U_SIZE \* 2`

echo "Free space in $W_FS: $W_A_SIZE, used space in /opt: $OPT_U_SIZE" >> $W_LOG

if [ `expr $W_A_SIZE - $N_SPACE` -lt 1048576 ]; then
  echo "No space avaliable for making images!" >> $W_LOG
  echo -n "2 No space avaliable for making images. Try deleting some books." > $RESFILE
  exit 1
fi 

# Copy /opt/ -> working directory
echo "Begin copy of /opt" >> $W_LOG
$tar -clf - -C /opt/ . | $tar xvpf - -C $W_DIR/new_opt/ >> $W_LOG 2>&1
echo "/opt copied to $W_DIR/new_opt/" >> $W_LOG

# Copy new files
echo "Begin copy of new files" >> $W_LOG
if ! $mcopy -pvns $M_CARD/files/opt/* $W_DIR/new_opt/ >> $W_LOG 2>&1; then
  echo -n "3 Error copying new files from $M_CARD/files/opt." > $RESFILE
  exit 1
fi
echo "New files copied" >> $W_LOG

# Creating cramfs
echo "Creating new cramfs image" >> $W_LOG
if ! $mkcramfs $W_DIR/new_opt/ $W_DIR/new_opt.img  >> $W_LOG 2>&1; then
  echo -n "4 Error creating new cramfs image. Not enough space?" > $RESFILE
  exit 1
fi
echo "Created cramfs $W_DIR/new_opt.img" >> $W_LOG

echo "Checking cramfs image size ...." >> $W_LOG
NEW_IMG_SIZE=`$du -b $W_DIR/new_opt.img | $cut -f 1`
echo "Cramfs image size: $NEW_IMG_SIZE" >> $W_LOG

if [ NEW_IMG_SIZE -gt OPT_IMG_SIZE ]; then
  echo "Opt image size is too big!" >> $W_LOG
  echo -n "5 The new cramfs image is too big for flashing." > $RESFILE
  exit 1
fi

# Flashing !!!
# $nblsdm create -i $W_DIR/new_opt.img Fsk
# $nblsdm cmp -i $W_DIR/new_opt.img Fsk
# $umount /opt
# $mtdmount -t cramfs Fsk /opt

# Debug
$mcopy -pvnso $W_DIR/new_opt.img $M_CARD/
echo "Image copied " >> $W_LOG
$date >> $W_LOG

#clear the temporary FS copy
if [ -d $W_DIR/new_opt ]; then
  $rm -rf $W_DIR/new_opt >> $W_LOG
fi

$mcopy -pnso $W_LOG $M_CARD/

echo -n "0 Image created successfully." > $RESFILE
sync
