#!/bin/sh
#
#       License: GPLv2
#       Author: fortwienix (http://www.mobileread.com/forums/member.php?u=109732)
#

# put your credentials here that you use to login at zeit.de
user=your_username
password=your_password

# filename of the stored file for the newspaper
fname_zeit='Die_Zeit'

# directory name where to store the downloaded files
target_dir=/mnt/ext1/zeits

# url of the login page
zeit_url="https://premium.zeit.de/abovorteile/cgi-bin/_er_member/p4z.fpl?ER_Do=createToken&Abo_RedirectTo=epaper.zeit.de/index_abovorteile.php&user=${user}&aboxnr="

# name of directory where temporary files are stored (relative to target_dir)
tmp_dir=zeit_tmp

# path of recompiled wget 1.12
wget_bin=/mnt/ext1/applications/tools/wget112

##### program starts here ######

# if the target directory doesn't exist, use the internal fs
if [ ! -d $target_dir ]; then
  target_dir=/mnt/ext1
fi
cd $target_dir

# clean out temp dir
if [ -d $tmp_dir ]; then 
  rm -rf $tmp_dir
fi
mkdir $tmp_dir
cd $tmp_dir

/ebrmain/bin/netagent connect

$wget_bin --user $user --password $password -O zeit_login $zeit_url

# get issue number
issue=$(cat zeit_login | grep DZ_ePaper | sed 's/.*DZ_ePaper_\([0-9][0-9]_[0-9][0-9]\)\.pdf.*/\1/' | uniq)
if [ "$issue " == " " ]; then
  issue=$$
fi

# download epub if it doesn't exist already
if [ ! -e ${target_dir}/${fname_zeit}_${issue}.epub ]; then
  cat zeit_login | grep '<a href' | grep die_zeit-abo | sed 's/.*href="\(.*\)".*/\1/' > zeit_dlink
  $wget_bin -O zeit$$.epub -i zeit_dlink
  rm zeit_dlink
  mv zeit$$.epub $target_dir/${fname_zeit}_${issue}.epub
fi

rm zeit_login
cd ..
rm -rf $tmp_dir

/ebrmain/bin/netagent disconnect
