#!/bin/sh
#
# $Id: install.sh 6845 2010-09-23 23:11:24Z NiLuJe $
#
# diff OTA patch script

# Hack specific config (name and when to start/stop)
HACKNAME="updates-provider"
HACK_HOME="/mnt/us/$HACKNAME"
KEY_DIR=/etc/uks
CONF_DIR="$HACK_HOME"
LOG_FILE="$HACK_HOME/install.log"


_FUNCTIONS=/etc/rc.d/functions
[ -f ${_FUNCTIONS} ] && . ${_FUNCTIONS}


MSG_SLLVL_D="debug"
MSG_SLLVL_I="info"
MSG_SLLVL_W="warn"
MSG_SLLVL_E="err"
MSG_SLLVL_C="crit"
MSG_SLNUM_D=0
MSG_SLNUM_I=1
MSG_SLNUM_W=2
MSG_SLNUM_E=3
MSG_SLNUM_C=4
MSG_CUR_LVL=/var/local/system/syslog_level

logmsg()
{
    local _NVPAIRS
    local _FREETEXT
    local _MSG_SLLVL
    local _MSG_SLNUM

    _MSG_LEVEL=$1
    _MSG_COMP=$2

    { [ $# -ge 4 ] && _NVPAIRS=$3 && shift ; }

    _FREETEXT=$3

    eval _MSG_SLLVL=\${MSG_SLLVL_$_MSG_LEVEL}
    eval _MSG_SLNUM=\${MSG_SLNUM_$_MSG_LEVEL}

    local _CURLVL

    { [ -f $MSG_CUR_LVL ] && _CURLVL=`cat $MSG_CUR_LVL` ; } || _CURLVL=1

    if [ $_MSG_SLNUM -ge $_CURLVL ]; then
        /usr/bin/logger -p local4.$_MSG_SLLVL -t "ota_install" "$_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
    fi

    if [ "$_MSG_LEVEL" != "D" ]; then
      echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT"
      # [ -d /mnt/us/$HACKNAME ] && echo "ota_install: $_MSG_LEVEL def:$_MSG_COMP:$_NVPAIRS:$_FREETEXT" >> $LOG_FILE
    fi
}

logmsg "I" "update" "remove switch-updates-provider init script"
rm -f /etc/init.d/switch-updates-provider
# Remove rc symlinks
for RC in 0 1 2 3 4 5 6
do
    rm -f /etc/rc$RC.d/S25switch-updates-provider
done

update_progressbar 33

# Restore original files
logmsg "I" "update" "restore original files"
mv -f "$KEY_DIR/pubprodkey01.pem.original" "$KEY_DIR/pubprodkey01.pem"
mv -f "$KEY_DIR/pubprodkey02.pem.original" "$KEY_DIR/pubprodkey02.pem"

# Remove the keys we copied
rm -f "$KEY_DIR/pubprodkey01.pem.hack"
rm -f "$KEY_DIR/pubprodkey02.pem.hack"
rm -f "$KEY_DIR/pubprodkey01.pem.amazon"
rm -f "$KEY_DIR/pubprodkey02.pem.amazon"

logmsg "I" "update" "remove config dir in user store"
update_progressbar 66
[ -d "$HACK_HOME" ] && rm -Rf "$HACK_HOME"

logmsg "I" "update" "done"
update_progressbar 100

return 0
