#! /bin/sh
#

HACKNAME="updates-provider"
PKGNAME="${HACKNAME}"
PKGVER="0.2"

KINDLE_MODELS="k3g k3w k3gb"
for model in ${KINDLE_MODELS} ; do
	# Prepare our files for this specific kindle model...
	ARCH=${PKGNAME}_${PKGVER}_${model}

	# Build install update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_install install.sh pubprodkey01.pem.amazon pubprodkey02.pem.amazon pubprodkey01.pem.hack pubprodkey02.pem.hack switch-updates-provider

	# Build uninstall update
	./kindle_update_tool.py m --sign --${model} ${ARCH}_uninstall uninstall.sh
done

# Pack the updates
zip ../${PKGNAME}_${PKGVER}.zip *.bin
rm -f *.bin
