#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_translations
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity

sleep 1

install_files() {
    # Overwrite files in current locale with new files
    # The words used in the applications
    cp -rf $THISDIR/locale/ /usr/share/
    # The words used in the settings icons
    cp -rf $THISDIR/ctb/ /usr/share/
}

if [ -e $ZENITY ]
then
    # Use dialog
    $ZENITY --question --title "Translations" --text "<b>Upgrade</b>\n\nDo you want to install the new translation files?"
    if [ $? -eq 0 ]; then
        install_files
        
        # TODO: Add dialog that indicates when/how new translation will be used
    fi
else
    # no dialog just install
    install_files
fi

# Todo: should _translations folder be removed after install?
