/*
 * File Name: menu.c
 */

/*
 * This file is part of hello-world-settings.
 *
 * hello-world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello-world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

// system include files, between < >
#include <stdio.h>
#include <unistd.h>

// ereader include files, between < >

// local include files, between " "
#include "log.h"
#include "i18n.h"
#include "ipc.h"
#include "main.h"
#include "menu.h"


//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Constants
//----------------------------------------------------------------------------

// menus for application, must be unique
static const char *MENU_MAIN = "mtool_settings_menu";
                                            

//----------------------------------------------------------------------------
// Static Variables
//----------------------------------------------------------------------------



//============================================================================
// Local Function Definitions
//============================================================================



//============================================================================
// Functions Implementation
//============================================================================

// initialise popup menu
void menu_init ( void ) 
{
    static gboolean firsttime = TRUE;

    LOGPRINTF("entry");

    // execute only once
    if ( !firsttime )
    {
        WARNPRINTF("function called twice");
        return;
    }
    firsttime = FALSE;

    // show an empty menu
    ipc_menu_add_menu( MENU_MAIN, NULL, NULL, NULL );
    menu_show();    
}


// remove the proper popup menu
void menu_destroy (void)
{
    LOGPRINTF("entry");

    // remove the main menu
    ipc_remove_menu( MENU_MAIN );
}


// show the proper popup menu
void menu_show (void)
{
    LOGPRINTF("entry");

    // show the main menu
    ipc_menu_show_menu( MENU_MAIN );
}

// set menu texts
void menu_set_text ( void ) 
{
    LOGPRINTF("entry");
}


//----------------------------------------------------------------------------
// Callbacks from popupmenu
//----------------------------------------------------------------------------

// user has pressed a menu button
void menu_on_item_activated ( const gchar *item,
                              const gchar *group,
                              const gchar *menu,
                              const gchar *state )
{
    gboolean    ok = TRUE;

    LOGPRINTF("entry: item [%s] group [%s]", item, group);

    // TODO: implement your menu handling here, if required
    WARNPRINTF("unexpected menu group [%s]", group);
    ok = FALSE;

    if (!ok)
    {
        ERRORPRINTF( "Unhandled menu items: menu [%s] group [%s] item [%s] state [%s]",
                                            menu,     group,     item,     state );
    }
}
