#ifndef __TASKBAR_H
#define __TASKBAR_H

/**
 * File Name  : taskbar.h
 *
 * Description: 
 */

/*
 * This file is part of popupmenu.
 *
 * popupmenu is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * popupmenu is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
 
/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

#if MACHINE_IS_DR1000S || MACHINE_IS_DR1000SW

void taskbar_create();

void taskbar_enable(gboolean enabled);

void taskbar_update_locale();

void taskbar_add_task(int xid, const char* label, const char* application, const char* document);

void taskbar_remove_task(int xid);
    
void taskbar_rename_task(int xid, const char* label);

void taskbar_select_task(int xid);

#endif

void taskbar_select_folder();

void testing_taskbar_print();

//------------------------- Functions for Last Opened documents/applications
void taskbar_store_tasks(int mode);

#endif

