#ifndef __DB_H__
#define __DB_H__

/**
 * File Name  : db.h
 *
 * Description: Content browser metadb interface
 */

/*
 * This file is part of ctb.
 *
 * ctb is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * ctb is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

#include <gtk/gtk.h>
#include <libermetadb/ermetadb.h>
#include "filemodel.h"

// columns in database table file_metadata
//   index in MDB_COLUMN_NAMES
typedef enum
        {
            COL_FILENAME = 0,
            COL_DIRECTORY_PATH,
            COL_SORT_PRIORITY,
            COL_IS_DIRECTORY,
            COL_FILETYPE,
            COL_FILESIZE,
            COL_FILETIME_MODIFIED,
            COL_FILETIME_LASTREAD,
            COL_FILETIME_ADDED,
            COL_TITLE,
            COL_AUTHOR,
            COL_THUMB_MINI,
            COL_THUMB_SMALL,
            COL_THUMB_MEDIUM,
            COL_THUMB_LARGE,
            N_METADATA_COLUMNS
        } mdb_column_idx_t;

erMetadb get_database();

void close_database();

int open_global_database ( const gchar *current_dir );

int db_query_create( int column1, ... );

int db_query_execute(int            sort_order,
                     gboolean       sort_asc, 
                     metadata_table **values,
                     const gchar    *tag_filter);

int db_query_execute_recent(int sort_order, metadata_table **values, int limit);

int db_query_execute_search_filter(int sort_order,
                                gboolean sort_asc,
                                metadata_table **values,
                                const gchar* search_filter);

int db_query_execute_path_filter(int sort_order,
                     gboolean sort_asc, 
                     metadata_table **values,
                     const gchar* path_filter,
                     gboolean show_filenames);

int db_query_get_metadata(const gchar* filename,
                          const gchar* dirpath,
                          metadata_table **values);

int db_query_update_lastread(const GString *filename, const GString *directory, int value);

int db_query_get_tag(const gchar* filename,
                     const gchar* dirpath,
                     metadata_table **values);
int db_query_update_tag(const gchar* filename, const gchar* directory, char *value);

int db_query_get_title(const gchar* filename,
                       const gchar* dirpath,
                       metadata_table **values);
int db_query_update_title(const gchar* filename, const gchar* directory, char *value);

int db_query_get_author(const gchar* filename,
                        const gchar* dirpath,
                        metadata_table **values);
int db_query_update_author(const gchar* filename, const gchar* directory, char *value);

#endif

