class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Newsweek'
    oldest_article = 30
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(name='article', attrs={'class':'article-text'})]
    remove_attributes = ['style', 'font']
    remove_tags = [dict(name='div', attrs={'class':['parbase image section','page-number','parbase section reference','section inlinelinks','inlinerelated section']}),
                   dict(name='h2', attrs={'class':'subhead'}),
                   dict(name='p', attrs={'class':'caption'}),
                   dict(name='span', attrs={'class':'photo-credit'}),
                   dict(name=['img','figure']),]

    feeds          = [(u'World', u'http://feeds.newsweek.com/newsweek/world?format=xml'), 
                          (u'Culture', u'http://feeds.newsweek.com/newsweek/culture?format=xml'), 
                          (u'Health', u'http://feeds.newsweek.com/newsweek/health?format=xml'), 
                          (u'Society', u'http://feeds.newsweek.com/newsweek/society'), 
                          (u'Technology', u'http://feeds.newsweek.com/newsweek/technology?format=xml')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds


