class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Lifehacker'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

   
    remove_tags_before = dict(name='div', attrs={'class':['content permalink']})
    remove_attributes = ['style', 'font','width','height']
    remove_tags = [dict(name='div', attrs={'class':['related','permalink_ads','postmeta_permalink_wrapper','presence_control_external smalltype']}),
                   dict(name='div', attrs={'id':['agegate_container_rejected','comments','footer']}),
                   dict(name='p', attrs={'class':['contactinfo']}),
                   dict(name='img'),]

    feeds = [(u'Windows Downloads', u'http://lifehacker.com/tag/featured-windows-download/index.xml'),
                  (u'Top Stories', u'http://lifehacker.com/tag/top/index.xml')
]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
