from calibre.web.feeds.news import BasicNewsRecipe

class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'InfoWorld'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                   

    keep_only_tags = [dict(name='div', attrs={'class':'article'})]
    remove_tags = [dict(name='div', attrs={'class':['byline','date','articleTools clearfix','tags']}),
                   dict(name='div', attrs={'id':['floating_tools']}),
                   dict(name='img'),]
   


    feeds          = [(u'News', u'http://www.infoworld.com/news/feed'), 
                          (u'Test Center', u'http://www.infoworld.com/testcenter/feed'), 
                          (u'Open Source', u'http://www.infoworld.com/taxonomy/term/3218/feed'), 
                          (u'Windows', u'http://www.infoworld.com/taxonomy/term/3213/feed')]




    def append_page(self, soup, appendtag, position):
        pager = soup.find('a',attrs={'class':'active'})
        if pager:
           nexturl = pager['href']
           soup2 = self.index_to_soup(nexturl)
           texttag = soup2.find('div', attrs={'class':'article'})
           for it in texttag.findAll(style=True):
               del it['style']
           newpos = len(texttag.contents)
           self.append_page(soup2,texttag,newpos)
           texttag.extract()
           appendtag.insert(position,texttag)


    def preprocess_html(self, soup):
        for item in soup.findAll(style=True):
            del item['style']
        for item in soup.findAll('div', attrs={'class':'edit-promo'}):
            item.extract()
        self.append_page(soup, soup.body, 3)
        pager = soup.find('div',attrs={'class':'pagination clearfix'})
        if pager:
           pager.extract()
        return soup

