class AdvancedUserRecipe1289668876(BasicNewsRecipe):
    title          = u'Gizmo'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                 
    
    remove_tags_before = dict(id='content')
    remove_tags = [dict(attrs={'class':['box','terms','links']}),
                              dict(id=['footer', 'sidebar-last','block-comment']),
                              dict(name='img')
                               ]

    feeds          = [(u'Freeware', u'http://feeds.feedburner.com/gizmosbest?format=xml'), 
                          (u'Daily Tech Treats', u'http://feeds.feedburner.com/GizmosDailyTechTreats?format=xml')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		