class AdvancedUserRecipe1289760920(BasicNewsRecipe):
    title          = u'Ghacks'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                

    remove_tags_before = dict(id='')
    remove_tags = [dict(name='div', attrs={'class':['navigation','alignright','sidebar3','sidebars','basement clr','clr','socialize-in-content']}),
                   dict(name='div', attrs={'id':['breadcrumbs','respond',]}),
                   dict(name='ul', attrs={'class':['bottomnav','extendspost']}),
                   dict(name='ol', attrs={'class':['commentlist']}),
                   dict(name='p', attrs={'class':['tags']}),
                   dict(name='h3', attrs={'id':['comments']}),
                   dict(name='img'),]

    feeds          = [(u'Windows', u'http://www.ghacks.net/category/windows/feed/'), (u'Portable Apps', u'http://www.ghacks.net/tag/portable-software/feed/')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		