class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Bodybuilding'
    oldest_article = 7
    max_articles_per_feed = 100
    
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(name='h1', attrs={'class':'main-header'})
    remove_attributes = ['style', 'font', 'bgcolor','width','height','table','color','strong','size']
    remove_tags = [
                   dict(name='div', attrs={'class':['related-content-bottom','related-content-clear']}),
                   dict(name='div', attrs={'id':['logoCon','navColumn','rightSideBar','footerContainer','bodyFooterLinks','headerCon','']}),
                   dict(name='div', attrs={'align':'center'}),
                   dict(name='ul', attrs={'id':['']}),
                   dict(name='img'),]

    feeds          = [(u'Training', u'http://www.bodybuilding.com/rss/articles/training'),
                         (u'Nutrition', u'http://www.bodybuilding.com/rss/articles/nutrition'),     
                         (u'Supplements', u'http://www.bodybuilding.com/rss/articles/supplements'),
                         (u'Mind Motivation', u'http://www.bodybuilding.com/rss/articles/mind')]

  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		