class AdvancedUserRecipe1290141997(BasicNewsRecipe):
    title          = u'UFC'
    oldest_article = 7
    max_articles_per_feed = 100

    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    keep_only_tags =[dict(name='div', attrs={'class':'main-section'})]
    remove_tags = [dict(name='div', attrs={'class':['active tab',' tab last','byline','comment-entry','bottom-comments','item-description ','media-item','intro']}),
                   dict(name='div', attrs={'id':['','',]}),
                   dict(name='img'),]
					

    feeds          = [(u'News', u'http://www.ufc.com/rss/news')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup