class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'CNN'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(id='')
    remove_attributes = ['style', 'font','width','height']
    remove_tags = [dict(name='div', attrs={'class':['cnnOverlayMenuContainer','cnnByline','cnn_strylftcntnt','cnn_strycaptiontxt','cnn_strybtntools','cnn_strybtmcntnt','cnn_strycrcntr']}),
                   dict(name='div', attrs={'id':['cnn_hdr','expand18','cnn_ftrcntnt']}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
	dict(name='ol', attrs={'id':['']}),
	dict(name='span', attrs={'class':['']}),
	dict(name='p', attrs={'id':''}),
                   dict(name='img'),]

    feeds          = [(u'World News', u'http://rss.cnn.com/rss/cnn_world.rss'), 
                          (u'Entertainment', u'http://rss.cnn.com/rss/cnn_showbiz.rss'), 
                          (u'Health', u'http://rss.cnn.com/rss/cnn_health.rss')]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds