class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Reuters'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    no_stylesheets = True
    encoding              = 'utf8'

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    
    keep_only_tags = [dict(id=['content'])]
    remove_attributes = ['style', 'font','']
    remove_tags = [dict(name='div', attrs={'class':['columnRight','relatedPhoto landscape','commentDisclaimer','relatedTopicButtons','articleComments','linebreak','socialComments','assetBuddy','gridPanel grid12','pageNavigation','module']}),
                   dict(name='div', attrs={'id':['commentForm','relatedInlineVideo','articleInfo','network-footer','most-popular','footer','slideshowInlineLarge','shareLinks','social-links','mostPopularDiscussed','marketplaceAd']}),
                   dict(name='ul', attrs={'class':['']}),
                   dict(name='ul', attrs={'id':['']}),
	dict(name='ol', attrs={'id':['']}),
	dict(name='span', attrs={'class':['']}),
	dict(name='p', attrs={'id':''}),
                    dict(name='img'),]

    feeds          = [(u'World News', u'http://feeds.reuters.com/reuters/worldNews?format=xml'), 
                          (u'Health', u'http://feeds.reuters.com/reuters/healthNews?format=xml'), 
                          (u'Entertainment', u'http://feeds.reuters.com/reuters/entertainment?format=xml'), 
                          (u'Music', u'http://feeds.reuters.com/reuters/musicNews?format=xml'), 
                          (u'People', u'http://feeds.reuters.com/reuters/peopleNews?format=xml'), 
                          (u'Media File', u'http://feeds.reuters.com/reuters/blogs/mediafile?format=xml'), 
                          (u'Internet News', u'http://feeds.reuters.com/Reuters/InternetNews?format=xml')
                          ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
              if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		
    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds