class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'MSNBC'
    oldest_article = 7
    max_articles_per_feed = 100
    summary_length         = 100  
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                  

   
    remove_tags =  [dict(name='div', attrs={'class':['txt timestamp','skip','nav t2','short-promo','content main s1',
                   'anchorPopular','ad-label','title','ad adX1','discuss_page_break','discussionContainer','chrome_footer',
                   'author_slice','recent_posts','comment_callout','drawer','time_value','time_unit','time_since_label',
                   'tweetbutton','adlabel','also','inlinePhoto photo_landscape photo_align_right ','vine-p p-content_Poll',
                   'inlinePhoto photo_landscape photo_align_right user_inline_photo']}),
                   dict(name='div', attrs={'id':['siteheader','adTextCustom','network','slice-3','slice-2','mostPopularLister',
                   'footer','wetbarcontainer','source','breadcrumbs','slice-4','explainer-nav','anchors','sitefooter','slice-5',
                    'most-popular','sidebar']}),
                   dict(name='ul', attrs={'class':['extshare hlist']}),
                   dict(name='span', attrs={'class':['copyright']}),
                   dict(name='ul', attrs={'id':['text-tools','msn','upscroll-grid']}),
                   dict(name='li', attrs={'class':['col i1 x1 label last','col i1 x2 label last']}),
                   dict(name='ol', attrs={'id':['scrollPins','inpagenav']}),
                   dict(name='p', attrs={'class':'handle'}),
                   dict(name='ol', attrs={'class':['stories','grid id-38962212 x2','grid id-39067451 x2','grid id-39065115 x1']}),
                   dict(name='span'), 
                   dict(name='h2', attrs={'id':'deck'}),
                   dict(name=['img','strong'])]

    feeds          = [(u'Fitness', u'http://rss.msnbc.msn.com/id/3034510/device/rss/rss.xml'), 
                          (u'Diet Nutrition', u'http://pheedo.msnbc.msn.com/id/13594277/device/rss/'), 
                          (u'Health', u'http://rss.msnbc.msn.com/id/3088327/device/rss/rss.xml'), 
                          (u'Mens Health', u'http://pheedo.msnbc.msn.com/id/3034560/device/rss/'), 
                          (u'Music', u'http://pheedo.msnbc.msn.com/id/3032432/device/rss/'), 
                          (u'Dateline', u'http://rss.msnbc.msn.com/id/3032599/device/rss/rss.xml'), 
                          (u'Gadgets', u'http://pheedo.msnbc.msn.com/id/3033117/device/rss/')]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		

    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'VIDEO' in article.title.upper() or 'VIDEO' in article.url:
            feed.articles.remove(article)
      return feeds