#!/tmp/busybox sh
################################################
echo "Pocketbook IQ701 app2sd installer v0.4"
################################################
EXTSIZE=512
SWAPSIZE=0

echo -n "preparing... "
export PATH=/tmp
busybox --install -s /tmp
chmod 755 /tmp/*
cd /tmp
echo "done"

do_automount() {

echo -n "automount... "
echo -n "#!/system/bin/sh 
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/\$SDNAME
mount -w -t ext2 \"\$SDPATH\"p2 /system/sd
mount -o bind /system/sd/app /data/app
mount -o bind /system/sd/app-private /data/app-private
mount -o bind /system/sd/data /data/data
" > /system/etc/install-recovery.sh
chmod 4755 /system/etc/install-recovery.sh
echo "done"

} ## automount

do_install() {

echo -n "rooting... "
cp -f su /system/bin
chmod 6755 /system/bin/su
cp SuperUser.apk /system/app
cp busybox /system/xbin
/system/xbin/busybox --install -s /system/xbin
cp parted e2fsck /system/xbin
echo -n 1 > /data/property/persist.service.adb.enable
echo "done"

echo -n "formatting... "
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/$SDNAME
SDSIZEMB=`parted $SDPATH unit MB print | grep $SDNAME | cut -d" " -f3`
SDSIZE=${SDSIZEMB%MB}
umount -f -l "$SDPATH" 2> /dev/null
umount -f -l "$SDPATH"p1
parted -s $SDPATH mklabel msdos
parted -s $SDPATH mkpartfs primary fat32 0 $(($SDSIZE-$EXTSIZE-$SWAPSIZE))MB
parted -s $SDPATH mkpartfs primary ext2 $(($SDSIZE-$EXTSIZE-$SWAPSIZE))MB $(($SDSIZE-$SWAPSIZE))MB
[ $SWAPSIZE -le 0 ] || parted -s $SDPATH mkpartfs primary linux-swap $(($SDSIZE-$SWAPSIZE))MB $(($SDSIZE))MB
echo "done"

echo === card info:
parted $SDPATH unit MB print all

echo -n "copying... "
mkdir -p /system/sd
mount -w -t ext2 "$SDPATH"p2 /system/sd
cp -a /data/app /system/sd 
rm -r /data/app 
cp -a /data/app-private /system/sd 
rm -r /data/app-private 
cp -a /data/data /system/sd 
rm -r /data/data 
echo "done"

do_automount

} ## install

do_disable() {
echo -n "disabling... "
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/$SDNAME
mount -w -t ext2 "$SDPATH"p2 /system/sd
cp -a /system/sd/app /data 
cp -a /system/sd/app-private /data 
cp -a /system/sd/data /data
rm /system/etc/install-recovery.sh
echo "done"
} ## disable

do_upgrade() {
echo "upgrading... "
rm /data/app 
rm /data/app-private 
rm /data/data 
do_automount
echo "done"
} ## upgrade

if [ ! -d /data/app ]
then do_upgrade
else if [ ! -f /system/etc/install-recovery.sh ]
then do_install
else do_disable
fi
fi
