#!/tmp/busybox sh
################################################
echo "Pocketbook IQ701 app2sd installer v0.2"
################################################
EXTSIZE=512
SWAPSIZE=0

echo -n "preparing... "
export PATH=/tmp
busybox --install -s /tmp
chmod 755 /tmp/*
echo "done"

do_install() {

echo -n "rooting... "
cp -f /tmp/su /system/bin/su
chmod 6755 /system/bin/su
cp /tmp/SuperUser.apk /system/app/SuperUser.apk
cp /tmp/busybox /system/xbin
/system/xbin/busybox --install -s /system/xbin
cp /tmp/parted /tmp/e2fsck /system/xbin
echo -n 1 > /data/property/persist.service.adb.enable
echo "done"

echo -n "formatting... "
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/$SDNAME
SDSIZEMB=`parted $SDPATH unit MB print | grep $SDNAME | cut -d" " -f3`
SDSIZE=${SDSIZEMB%MB}
umount -f -l "$SDPATH"
umount -f -l "$SDPATH"p1
parted -s "$SDPATH" mklabel msdos
parted -s "$SDPATH" mkpartfs primary fat32 0 $(($SDSIZE-$EXTSIZE-$SWAPSIZE))MB
parted -s "$SDPATH" mkpartfs primary ext2 $(($SDSIZE-$EXTSIZE-$SWAPSIZE))MB $(($SDSIZE-$SWAPSIZE))MB
#parted -s "$SDPATH" mkpartfs primary linux-swap $(($SDSIZE-$SWAPSIZE))MB $(($SDSIZE))MB
echo "done"

echo === card info:
parted $SDPATH unit MB print all
echo ===

echo -n "copying... "
mkdir -p /system/sd
mount -w -t ext2 "$SDPATH"p2 /system/sd
cp -a /data/app /system/sd 
cp -a /data/app-private /system/sd 
cp -a /data/data /system/sd 
echo "done"

echo -n "automount... "
echo -n "#!/system/bin/sh 
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/\$SDNAME
/system/bin/mount -w -t ext2 \"\$SDPATH\"p2 /system/sd
" > /system/etc/install-recovery.sh
chmod 4755 /system/etc/install-recovery.sh
echo "done"

echo -n "enabling... "
rm -r /data/app 
ln -s /system/sd/app /data/app
rm -r /data/app-private 
ln -s /system/sd/app-private /data/app-private 
rm -r /data/data 
ln -s /system/sd/data /data/data
echo "done"

} ## install

do_disable() {

echo -n "disabling... "
SDNAME=mmcblk1
if [ ! -b /dev/block/mmcblk1 ]; then SDNAME=mmcblk0; fi
SDPATH=/dev/block/$SDNAME
mount -w -t ext2 "$SDPATH"p2 /system/sd
rm /data/app 
cp -a /system/sd/app /data 
rm /data/app-private 
cp -a /system/sd/app-private /data 
rm /data/data 
cp -a /system/sd/data /data
echo "done"

} ## disable

if [ -d /data/app ]
then do_install
else do_disable
fi
