__license__ = 'GPL 3'
__copyright__ = '2009, John Schember <john@nachtimwald.com>'
__docformat__ = 'restructuredtext en'

'''
Device driver for IRex Digital Reader
'''

import re

from calibre.devices.usbms.driver import USBMS

class IREXDR800(USBMS):
    
    name           = 'IRex Digital Reader 800 Device Interface'
    description    = _('Communicate with the IRex Digital Reader 800, all formats')
    author         = _('John Schember')
    supported_platforms = ['windows', 'osx', 'linux']

    # Ordered list of supported formats
    # Be sure these have an entry in calibre.devices.mime

    FORMATS     = ['epub', 'pdb','mobi', 'prc', 'html', 'pdf', 'djvu', 'txt', 'fb2', 'plucker', 'oeb', 'ztxt', 'tcr', 'chm', 'rtf', 'cbz']
    
    PRODUCT_ID = [0x002]
    
    VENDOR_NAME = 'IREX'
    WINDOWS_MAIN_MEM = 'DR800'

    EBOOK_DIR_MAIN = 'Books'
    DELETE_EXTS = []
    SUPPORTS_SUB_DIRS = True

