/*
 * File Name: dialog.c
 */

/*
 * This file is part of hello-world.
 *
 * hello-world is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * hello-world is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Copyright (C) 2009 iRex Technologies B.V.
 * All rights reserved.
 */

//----------------------------------------------------------------------------
// Include Files
//----------------------------------------------------------------------------

// system include files, between < >
#include <glib.h>
#include <gtk/gtk.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>

//----------------------------------------------------------------------------
// Type Declarations
//----------------------------------------------------------------------------


//----------------------------------------------------------------------------
// Constants
//----------------------------------------------------------------------------

GtkWidget       *g_main_window;


//============================================================================
// Functions Implementation
//============================================================================

// print usage text and quit
static void usage (const char *argv_0)
{
    static const char *usage_text = 
                        "\n"
                        "usage: %s <message>\n";

    printf(usage_text, argv_0);

    exit(1);
}

// terminate application
void main_quit (void)
{
    if (g_main_window)
    {
        gtk_widget_destroy(g_main_window);
        g_main_window = NULL;
    }    
    
    if (gtk_main_level() > 0)
    {
        gtk_main_quit();
    }
    else
    {
        _exit(0);
    }
}

// run error dialog
static gboolean run_error_dialog (gpointer data)
{
    GtkWidget   *dialog = NULL;
    gchar *msg = (gchar *) data;

    printf("Show dialog with message: [%s]\n", msg);

    dialog = gtk_message_dialog_new( GTK_WINDOW(g_main_window),
                                     GTK_DIALOG_DESTROY_WITH_PARENT,
                                     GTK_MESSAGE_INFO, //GTK_MESSAGE_ERROR,
                                     GTK_BUTTONS_OK,
                                     msg );

    gtk_dialog_run( GTK_DIALOG(dialog) );
    gtk_widget_destroy( dialog );
    main_quit();
    
    return FALSE;
}

// main function
int main (int argc, char *argv[])
{
    gchar *msg = NULL;

    // check command-line arguments
    if (argc < 2)
    {
        usage(argv[0]);
    }

    // init gtk, list the default rc files
    gtk_init(&argc, &argv);

    // create the top level window 
    g_main_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

    if (argc > 0)
    {
        msg = g_strdup_printf("%s", argv[1]);
        g_idle_add(run_error_dialog, (gpointer) msg);
    }
    
    gtk_main();
    g_free(msg);

    return 0;
}

