#!/bin/sh

THISDIR=/media/mmcblk0p1/Programs/_mackxpatch
INSTALLERDIR=/media/mmcblk0p1/Programs/Install
ZENITY=/media/mmcblk0p1/Programs/_base/bin/zenity
MTAG=/media/mmcblk0p1/Programs/_mackxpatch/bin/mtag

cd $THISDIR

install_schemas () {
	# Adapt gconf to enable the new views
	export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
	# Install schemas for standard icons on Home-View
	/bin/cp -f ./schemas/standard.schemas /etc/gconf/schemas/standard.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/standard.schemas

	# Application View
	/bin/cp -f ./schemas/applications.schemas /etc/gconf/schemas/applications.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/applications.schemas

	# Installers View
	/bin/cp -f ./schemas/installers.schemas /etc/gconf/schemas/installers.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/installers.schemas
	# copy the icons
	/bin/cp -f ./icons/icon-download-medium.png /usr/share/ctb/icon-download-medium.png
	/bin/cp -f ./icons/icon-download-small.png /usr/share/ctb/icon-download-small.png
	/bin/chmod a-x /usr/share/ctb/icon-download-*

	# Favourites View
	/bin/cp -f ./schemas/favourites.schemas /etc/gconf/schemas/favourites.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/favourites.schemas

	# Recently Read View
	/bin/cp -f ./schemas/recently_read.schemas /etc/gconf/schemas/recently_read.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/recently_read.schemas

	# Xournal View
	/bin/cp -f ./schemas/xournal.schemas /etc/gconf/schemas/xournal.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/xournal.schemas

	# Disable build-in views
	# gconftool-2 --type string --set /apps/er/patch/ctb/views/recent/mode "disabled"

	# Enable the appropriate views
	gconftool-2 --type string --set /apps/er/patch/ctb/views/application/mode "enabled"
	gconftool-2 --type string --set /apps/er/patch/ctb/views/installer/mode "enabled"
	gconftool-2 --type string --set /apps/er/patch/ctb/views/favourite/mode "enabled"
	gconftool-2 --type string --set /apps/er/patch/ctb/views/recentlyread/mode "enabled"
	gconftool-2 --type string --set /apps/er/patch/ctb/views/xournal/mode "enabled"

	# Create Backup of dr.ini
	/bin/cp -f /media/mmcblk0p1/System/dr.ini /media/mmcblk0p1/System/dr.patch.ini
	# and save the (just modified) settings to disk
	/usr/bin/erconftool -e /apps/er
	
	# These settings are only used after a reboot of the system, so when creating a script
	# to add extra Views, also add a reboot of the device (see below).
}

install_mandatory_schemas () {
	# Adapt gconf to enable the new views
	export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

	# Entries for last apps
	/bin/cp -f ./schemas/last_apps.schemas /etc/gconf/schemas/last_apps.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/last_apps.schemas

	# Entries for startup view
	/bin/cp -f ./schemas/ctb_view.schemas /etc/gconf/schemas/ctb_view.schemas
	gconftool-2 --makefile-install-rule /etc/gconf/schemas/ctb_view.schemas

	# user-views can have different numbers when new user views are installed, so set
	# startup view to 0 after install
	#gconftool-2 --type int --set /apps/er/patch/ctb/startupmode 0
	# Make sure that after install no document is started automatically
	gconftool-2 --type int --set /apps/er/lastapps/active 0
}

backup_firmware () {
	# Save originals ONLY if they do not exists
	if [ ! -e $THISDIR/ctb_original ]
	then
		/bin/cp -f /usr/bin/ctb $THISDIR/ctb_original
	fi

	if [ ! -e $THISDIR/popupmenu_original ]
	then
		/bin/cp -f /usr/bin/popupmenu $THISDIR/popupmenu_original
	fi

	if [ ! -e $THISDIR/sysd_original ]
	then
		/bin/cp -f /usr/bin/sysd $THISDIR/sysd_original
	fi

	if [ ! -e $THISDIR/libermetadb_original ]
	then
		/bin/cp -f /usr/lib/libermetadb.so.0.0.0 $THISDIR/libermetadb_original
	fi

	if [ ! -e $THISDIR/globaldb_original ]
	then
		/bin/cp -f /usr/share/ctb/settings/global.db $THISDIR/globaldb_original
	fi
}

install_patched_files () {
	# copy new files
	/bin/cp -f $THISDIR/bin/ctb /usr/bin/
	/bin/cp -f $THISDIR/bin/popupmenu /usr/bin/
	/bin/cp -f $THISDIR/bin/sysd /usr/bin/
	/bin/cp -f $THISDIR/lib/libermetadb.so.0.0.0 /usr/lib/

	/bin/cp -f $THISDIR/share/ctb/settings/global.db /usr/share/ctb/settings/
	/bin/cp -f $THISDIR/share/ctb/settings/mackx_patch.desktop /usr/share/ctb/settings/
	/bin/cp -f $THISDIR/share/ctb/settings/lastapps.desktop /usr/share/ctb/settings/
	#/bin/cp -f $THISDIR/mxp_version /etc/
}

remove_unused_files () {
    # These files are not needed anymore, so remove them
	/bin/rm -f $INSTALLERDIR/AddAnyFolderView.desktop
	/bin/rm -f $INSTALLERDIR/RestoreMackxPatch.desktop
	/bin/rm -f $THISDIR/_add_anyfolder_view.sh
	/bin/rm -f $THISDIR/_restore.sh
}

restore_original_files () {
	# Restore the original program(s)
	if [ -e $THISDIR/ctb_original ]
	then
		/bin/cp $THISDIR/ctb_original /usr/bin/ctb
		/bin/rm -f $THISDIR/ctb_original
	fi

	if [ -e $THISDIR/popupmenu_original ]
	then
		/bin/cp $THISDIR/popupmenu_original /usr/bin/popupmenu
		/bin/rm -f $THISDIR/popupmenu_original
	fi

	if [ -e $THISDIR/sysd_original ]
	then
		/bin/cp $THISDIR/sysd_original /usr/bin/sysd
		/bin/rm -f $THISDIR/sysd_original
	fi

	if [ -e $THISDIR/libermetadb_original ]
	then
		/bin/cp $THISDIR/libermetadb_original /usr/lib/libermetadb.so.0.0.0
		/bin/rm -f $THISDIR/libermetadb_original
	fi

	if [ -e $THISDIR/globaldb_original ]
	then
		/bin/cp $THISDIR/globaldb_original /usr/share/ctb/settings/
		/bin/rm -f $THISDIR/globaldb_original
	fi

	# /bin/rm -f /etc/mxp_version
	
	# TODO: should gconf settings also be removed? On the next install the available settings
	#       will be used automatically
}

add_tags_to_files () {
    # Mark the desktop file as Installer so it will show up in the installer view
	# When using this tool the syntax is: 
	# mtag     [file]                            [title]           [author] [tag]
	$MTAG $INSTALLERDIR/ApplyMackxPatch.desktop 'Install Mackx Hack' Mackx install
	# Valid tags, used by this hack are: application, fav1, install and xournal.
	# see also _mackxpatch/schemas
}


if [ -f $THISDIR/ctb_original ]; then
    $ZENITY --question --title "MackxPatch" --text "<b>De-install</b>\n\nDo you want to restore original IREX programs?"
    if [ $? -eq 0 ]; then
		echo "Restoring original files"
		restore_original_files
		
		$ZENITY --info --title "MackxPatch" --text "<b>Patch Removed</b>\n\nPress ok to reboot"
		/sbin/reboot
		sleep 31
	fi
fi

$ZENITY --question --title "MackxPatch" --text "<b>Upgrade</b>\n\nDo you want to install MackxPatch?"
if [ $? -eq 0 ]; then
	# We will only come here if de-install was not choosen!!

    # do mandatory schemas first
    install_mandatory_schemas
	
	# Ask if views need to be installed
	$ZENITY --question --title "MackxPatch" --text "<b>Document Views</b>\n\nDo you want to install the schemas for the new Views?"
	if [ $? -eq 0 ]; then
		echo "Installing schemas for new views"
		install_schema
	else
		echo "Not installing views"
	fi

	echo "Backingup original firmware files"
	backup_firmware

	echo "Installing patch"
	remove_unused_files
	install_patched_files
	add_tags_to_files

	# For the new version to be used, a reset is needed
	$ZENITY --info --title "MackxPatch" --text "<b>Patch Applied</b>\n\nPress ok to reboot"
	/sbin/reboot
	sleep 31
fi
	