/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.opf;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ocf.OCFPackage;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.OPFReference;
import com.adobe.epubcheck.util.PathUtil;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLParser;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class OPFHandler
implements XMLHandler {
    OCFPackage ocf;
    XMLParser parser;
    Hashtable itemMapById = new Hashtable();
    Hashtable itemMapByPath = new Hashtable();
    Hashtable encryptedItems;
    Vector spine = new Vector();
    Vector items = new Vector();
    Vector refs = new Vector();
    static HashSet validRoles = new HashSet();
    String path;
    String uniqueIdent;
    boolean uniqueIdentExists = false;
    OPFItem toc;
    boolean opf12PackageFile = false;

    OPFHandler(XMLParser parser, OCFPackage ocf, String path) {
        this.ocf = ocf;
        this.parser = parser;
        this.path = path;
    }

    public boolean getOpf12PackageFile() {
        return this.opf12PackageFile;
    }

    public boolean getOpf20PackageFile() {
        return !this.opf12PackageFile;
    }

    public OPFItem getTOC() {
        return this.toc;
    }

    public OPFItem getItemById(String id) {
        return (OPFItem)this.itemMapById.get(id);
    }

    public OPFItem getItemByPath(String path) {
        return (OPFItem)this.itemMapByPath.get(path);
    }

    public int getSpineItemCount() {
        return this.spine.size();
    }

    public OPFItem getSpineItem(int index) {
        return (OPFItem)this.spine.elementAt(index);
    }

    public int getItemCount() {
        return this.items.size();
    }

    public OPFItem getItem(int index) {
        return (OPFItem)this.items.elementAt(index);
    }

    public int getReferenceCount() {
        return this.refs.size();
    }

    public OPFReference getReference(int index) {
        return (OPFReference)this.refs.elementAt(index);
    }

    public boolean checkUniqueIdentExists() {
        return this.uniqueIdentExists;
    }

    public void setEncryptedItems(Hashtable encryptedItems) {
        this.encryptedItems = encryptedItems;
    }

    private static boolean isValidRole(String role) {
        return validRoles.contains(role) || role.startsWith("oth.");
    }

    public void startElement() {
        boolean registerEntry = true;
        XMLElement e = this.parser.getCurrentElement();
        String ns = e.getNamespace();
        if (ns == null || ns.equals("") || ns.equals("http://openebook.org/namespaces/oeb-package/1.0/") || ns.equals("http://www.idpf.org/2007/opf")) {
            String name = e.getName();
            if (name.equals("package")) {
                String uniqueIdentAttr;
                if (!ns.equals("http://www.idpf.org/2007/opf")) {
                    this.parser.getReport().warning(this.path, this.parser.getLineNumber(), "OPF file is using OEBPS 1.2 syntax allowing backwards compatibility");
                    this.opf12PackageFile = true;
                }
                if ((uniqueIdentAttr = e.getAttribute("unique-identifier")) != null && !uniqueIdentAttr.equals("")) {
                    this.uniqueIdent = uniqueIdentAttr;
                } else {
                    this.parser.getReport().error(this.path, this.parser.getLineNumber(), "unique-identifier attribute in package element must be present and have a value");
                }
            } else if (name.equals("item")) {
                String id = e.getAttribute("id");
                String href = e.getAttribute("href");
                if (href != null) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                    }
                    catch (IllegalArgumentException ex) {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), ex.getMessage());
                        href = null;
                    }
                }
                String mimeType = e.getAttribute("media-type");
                String fallback = e.getAttribute("fallback");
                String fallbackStyle = e.getAttribute("fallback-style");
                String namespace = e.getAttribute("island-type");
                OPFItem item = new OPFItem(id, href, mimeType, fallback, fallbackStyle, namespace, this.parser.getLineNumber());
                if (id != null) {
                    this.itemMapById.put(id, item);
                }
                if (href != null && registerEntry) {
                    this.itemMapByPath.put(href, item);
                    this.items.add(item);
                }
            } else if (name.equals("reference")) {
                String type = e.getAttribute("type");
                String title = e.getAttribute("title");
                String href = e.getAttribute("href");
                if (href != null) {
                    try {
                        href = PathUtil.resolveRelativeReference(this.path, href);
                    }
                    catch (IllegalArgumentException ex) {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), ex.getMessage());
                        href = null;
                    }
                }
                OPFReference ref = new OPFReference(type, title, href, this.parser.getLineNumber());
                this.refs.add(ref);
            } else if (name.equals("spine")) {
                String idref = e.getAttribute("toc");
                if (idref != null) {
                    this.toc = (OPFItem)this.itemMapById.get(idref);
                    if (this.toc == null) {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), "item with id '" + idref + "' not found");
                    } else {
                        this.toc.setNcx(true);
                        if (this.toc.getMimeType() != null && !this.toc.getMimeType().equals("application/x-dtbncx+xml")) {
                            this.parser.getReport().error(this.path, this.parser.getLineNumber(), "toc attribute references resource with non-NCX mime type; \"application/x-dtbncx+xml\" is expected");
                        }
                    }
                }
            } else if (name.equals("itemref")) {
                String idref = e.getAttribute("idref");
                if (idref != null) {
                    OPFItem item = this.getItemById(idref);
                    if (item != null) {
                        this.spine.add(item);
                        item.setInSpine(true);
                    } else {
                        this.parser.getReport().error(this.path, this.parser.getLineNumber(), "item with id '" + idref + "' not found");
                    }
                }
            } else if ((name.equals("dc-metadata") || name.equals("x-metadata")) && !this.opf12PackageFile) {
                this.parser.getReport().error(this.path, this.parser.getLineNumber(), "use of deprecated element '" + name + "'");
            }
        } else if (ns.equals("http://purl.org/dc/elements/1.1/")) {
            String role;
            String name = e.getName();
            if (name.equals("identifier")) {
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent)) {
                    this.uniqueIdentExists = true;
                }
            } else if (name.equals("creator") && (role = e.getAttributeNS("http://www.idpf.org/2007/opf", "role")) != null && !role.equals("") && !OPFHandler.isValidRole(role)) {
                this.parser.getReport().error(this.path, this.parser.getLineNumber(), "role value '" + role + "' is not valid");
            }
        }
    }

    public boolean isNotRequiredContent(String href) {
        if (href.endsWith(".opf")) {
            return false;
        }
        if (href.endsWith(".html")) {
            return false;
        }
        if (href.endsWith(".ncx")) {
            return false;
        }
        if (href.endsWith(".xpgt")) {
            return false;
        }
        return !href.endsWith(".xhtml");
    }

    public void endElement() {
        XMLElement e = this.parser.getCurrentElement();
        if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/")) {
            String name = e.getName();
            if (name.equals("identifier")) {
                String idval;
                String idAttr = e.getAttribute("id");
                if (idAttr != null && !idAttr.equals("") && idAttr.equals(this.uniqueIdent) && (idval = (String)e.getPrivateData()) != null) {
                    this.ocf.setUniqueIdentifier(idval);
                }
            } else if (name.equals("date")) {
                String dateval = (String)e.getPrivateData();
                DateParser dateParser = new DateParser();
                boolean iso8601 = false;
                if (dateval != null) {
                    try {
                        DateParser.parse(dateval);
                        iso8601 = true;
                    }
                    catch (InvalidDateException d) {
                        iso8601 = false;
                    }
                }
                if (!iso8601) {
                    Report report = this.parser.getReport();
                    report.error(this.path, this.parser.getLineNumber(), "date value '" + (dateval == null ? "" : dateval) + "' is not valid. The date must be in the form YYYY, YYYY-MM or YYYY-MM-DD (e.g., \"1993\", \"1993-05\", or \"1993-05-01\"). See http://www.w3.org/TR/NOTE-datetime.");
                }
            }
        }
    }

    public void ignorableWhitespace(char[] chars, int arg1, int arg2) {
    }

    public void characters(char[] chars, int start, int len) {
        String name;
        XMLElement e = this.parser.getCurrentElement();
        if (e.getNamespace().equals("http://purl.org/dc/elements/1.1/") && ((name = e.getName()).equals("identifier") || name.equals("date"))) {
            String val = (String)e.getPrivateData();
            String text = new String(chars, start, len);
            val = val == null ? text : val + text;
            e.setPrivateData(val);
        }
    }

    public void processingInstruction(String arg0, String arg1) {
    }

    static {
        String[] list = new String[]{"acp", "act", "adp", "aft", "anl", "anm", "ann", "ant", "app", "aqt", "arc", "ard", "arr", "art", "asg", "asn", "att", "auc", "aud", "aui", "aus", "aut", "bdd", "bjd", "bkd", "bkp", "bnd", "bpd", "bsl", "ccp", "chr", "clb", "cli", "cll", "clt", "cmm", "cmp", "cmt", "cng", "cnd", "cns", "coe", "col", "com", "cos", "cot", "cov", "cpc", "cpe", "cph", "cpl", "cpt", "cre", "crp", "crr", "csl", "csp", "cst", "ctb", "cte", "ctg", "ctr", "cts", "ctt", "cur", "cwt", "dfd", "dfe", "dft", "dgg", "dis", "dln", "dnc", "dnr", "dpc", "dpt", "drm", "drt", "dsr", "dst", "dtc", "dte", "dtm", "dto", "dub", "edt", "egr", "elg", "elt", "eng", "etr", "exp", "fac", "fld", "flm", "fmo", "fpy", "fnd", "frg", "gis", "grt", "hnr", "hst", "ill", "ilu", "ins", "inv", "itr", "ive", "ivr", "lbr", "lbt", "ldr", "led", "lee", "lel", "len", "let", "lgd", "lie", "lil", "lit", "lsa", "lse", "lso", "ltg", "lyr", "mcp", "mfr", "mdc", "mod", "mon", "mrk", "msd", "mte", "mus", "nrt", "opn", "org", "orm", "oth", "own", "pat", "pbd", "pbl", "pdr", "pfr", "pht", "plt", "pma", "pmn", "pop", "ppm", "ppt", "prc", "prd", "prf", "prg", "prm", "pro", "prt", "pta", "pte", "ptf", "pth", "ptt", "rbr", "rce", "rcp", "red", "ren", "res", "rev", "rps", "rpt", "rpy", "rse", "rsg", "rsp", "rst", "rth", "rtm", "sad", "sce", "scl", "scr", "sds", "sec", "sgn", "sht", "sng", "spk", "spn", "spy", "srv", "std", "stl", "stm", "stn", "str", "tcd", "tch", "ths", "trc", "trl", "tyd", "tyg", "vdg", "voc", "wam", "wdc", "wde", "wit"};
        for (int i = 0; i < list.length; ++i) {
            validRoles.add(list[i]);
        }
    }
}

