/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.mime;

import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.w3c.tools.sorter.Sorter;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public class Utils {
    private static Hashtable extension_map = new Hashtable();
    private static Hashtable charset_map = new Hashtable();

    private static void setSuffix(String string, String string2) {
        extension_map.put(string, string2);
    }

    private static void setCharset(String string, String string2) {
        charset_map.put(string, string2);
    }

    public static String guessContentTypeFromName(String string) {
        String string2 = "";
        int n = string.lastIndexOf(35);
        if (n != -1) {
            string = string.substring(0, n - 1);
        }
        n = string.lastIndexOf(46);
        n = Math.max(n, string.lastIndexOf(47));
        if ((n = Math.max(n, string.lastIndexOf(63))) != -1 && string.charAt(n) == '.' && ++n < string.length()) {
            string2 = string.substring(n).toLowerCase();
        }
        return (String)extension_map.get(string2);
    }

    public static MimeType getMimeType(String string) {
        try {
            return new MimeType(Utils.guessContentTypeFromName(string));
        }
        catch (MimeTypeFormatException mimeTypeFormatException) {
            return null;
        }
    }

    public static Vector getKnownMimeTypesinVector() {
        return Sorter.sortStringEnumeration(extension_map.elements());
    }

    public static String[] getKnownMimeTypes() {
        Vector vector = Sorter.sortStringEnumeration(extension_map.elements());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector getKnownExtensionsinVector() {
        return Sorter.sortStringEnumeration(extension_map.keys());
    }

    public static String[] getKnownExtensions() {
        Vector vector = Sorter.sortStringEnumeration(extension_map.keys());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector getKnownLanguagesinVector() {
        return Sorter.sortStringEnumeration(charset_map.keys());
    }

    public static String[] getKnownLanguages() {
        Vector vector = Sorter.sortStringEnumeration(charset_map.keys());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Vector getKnownCharsetsinVector() {
        return Sorter.sortStringEnumeration(charset_map.elements());
    }

    public static String[] getKnownCharsets() {
        Vector vector = Sorter.sortStringEnumeration(charset_map.elements());
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String getCharset(Locale locale) {
        return Utils.getCharset(locale.getLanguage());
    }

    public static String getCharset(String string) {
        return (String)charset_map.get(string);
    }

    static {
        Utils.setSuffix("", "content/unknown");
        Utils.setSuffix("uu", "application/octet-stream");
        Utils.setSuffix("saveme", "application/octet-stream");
        Utils.setSuffix("dump", "application/octet-stream");
        Utils.setSuffix("hqx", "application/octet-stream");
        Utils.setSuffix("arc", "application/octet-stream");
        Utils.setSuffix("o", "application/octet-stream");
        Utils.setSuffix("a", "application/octet-stream");
        Utils.setSuffix("bin", "application/octet-stream");
        Utils.setSuffix("exe", "application/octet-stream");
        Utils.setSuffix("z", "application/octet-stream");
        Utils.setSuffix("gz", "application/octet-stream");
        Utils.setSuffix("jar", "application/octet-stream");
        Utils.setSuffix("oda", "application/oda");
        Utils.setSuffix("pdf", "application/pdf");
        Utils.setSuffix("eps", "application/postscript");
        Utils.setSuffix("ai", "application/postscript");
        Utils.setSuffix("ps", "application/postscript");
        Utils.setSuffix("rtf", "application/rtf");
        Utils.setSuffix("dvi", "application/x-dvi");
        Utils.setSuffix("hdf", "application/x-hdf");
        Utils.setSuffix("latex", "application/x-latex");
        Utils.setSuffix("cdf", "application/x-netcdf");
        Utils.setSuffix("nc", "application/x-netcdf");
        Utils.setSuffix("tex", "application/x-tex");
        Utils.setSuffix("texinfo", "application/x-texinfo");
        Utils.setSuffix("texi", "application/x-texinfo");
        Utils.setSuffix("t", "application/x-troff");
        Utils.setSuffix("tr", "application/x-troff");
        Utils.setSuffix("roff", "application/x-troff");
        Utils.setSuffix("man", "application/x-troff-man");
        Utils.setSuffix("me", "application/x-troff-me");
        Utils.setSuffix("ms", "application/x-troff-ms");
        Utils.setSuffix("src", "application/x-wais-source");
        Utils.setSuffix("wsrc", "application/x-wais-source");
        Utils.setSuffix("zip", "application/zip");
        Utils.setSuffix("bcpio", "application/x-bcpio");
        Utils.setSuffix("cpio", "application/x-cpio");
        Utils.setSuffix("gtar", "application/x-gtar");
        Utils.setSuffix("shar", "application/x-shar");
        Utils.setSuffix("sh", "application/x-shar");
        Utils.setSuffix("sv4cpio", "application/x-sv4cpio");
        Utils.setSuffix("sv4crc", "application/x-sv4crc");
        Utils.setSuffix("tar", "application/x-tar");
        Utils.setSuffix("ustar", "application/x-ustar");
        Utils.setSuffix("snd", "audio/basic");
        Utils.setSuffix("au", "audio/basic");
        Utils.setSuffix("aifc", "audio/x-aiff");
        Utils.setSuffix("aif", "audio/x-aiff");
        Utils.setSuffix("aiff", "audio/x-aiff");
        Utils.setSuffix("wav", "audio/x-wav");
        Utils.setSuffix("gif", "image/gif");
        Utils.setSuffix("ief", "image/ief");
        Utils.setSuffix("jfif", "image/jpeg");
        Utils.setSuffix("jfif-tbnl", "image/jpeg");
        Utils.setSuffix("jpe", "image/jpeg");
        Utils.setSuffix("jpg", "image/jpeg");
        Utils.setSuffix("jpeg", "image/jpeg");
        Utils.setSuffix("tif", "image/tiff");
        Utils.setSuffix("tiff", "image/tiff");
        Utils.setSuffix("ras", "image/x-cmu-rast");
        Utils.setSuffix("pnm", "image/x-portable-anymap");
        Utils.setSuffix("pbm", "image/x-portable-bitmap");
        Utils.setSuffix("pgm", "image/x-portable-graymap");
        Utils.setSuffix("ppm", "image/x-portable-pixmap");
        Utils.setSuffix("rgb", "image/x-rgb");
        Utils.setSuffix("png", "image/png");
        Utils.setSuffix("xbm", "image/x-xbitmap");
        Utils.setSuffix("xml", "text/xml");
        Utils.setSuffix("xsl", "text/xml");
        Utils.setSuffix("xsd", "text/xml");
        Utils.setSuffix("xpm", "image/x-xpixmap");
        Utils.setSuffix("xwd", "image/x-xwindowdump");
        Utils.setSuffix("htm", "text/html");
        Utils.setSuffix("html", "text/html");
        Utils.setSuffix("xhtm", "application/xhtml+xml");
        Utils.setSuffix("xhtml", "application/xhtml+xml");
        Utils.setSuffix("css", "text/css");
        Utils.setSuffix("text", "text/plain");
        Utils.setSuffix("c", "text/plain");
        Utils.setSuffix("cc", "text/plain");
        Utils.setSuffix("c++", "text/plain");
        Utils.setSuffix("h", "text/plain");
        Utils.setSuffix("pl", "text/plain");
        Utils.setSuffix("txt", "text/plain");
        Utils.setSuffix("java", "text/plain");
        Utils.setSuffix("rtx", "application/rtf");
        Utils.setSuffix("tsv", "texyt/tab-separated-values");
        Utils.setSuffix("etx", "text/x-setext");
        Utils.setSuffix("mpg", "video/mpeg");
        Utils.setSuffix("mpe", "video/mpeg");
        Utils.setSuffix("mpeg", "video/mpeg");
        Utils.setSuffix("mov", "video/quicktime");
        Utils.setSuffix("qt", "video/quicktime");
        Utils.setSuffix("avi", "application/x-troff-msvideo");
        Utils.setSuffix("movie", "video/x-sgi-movie");
        Utils.setSuffix("mv", "video/x-sgi-movie");
        Utils.setSuffix("mime", "message/rfc822");
        Utils.setSuffix("smi", "application/smil");
        Utils.setSuffix("smil", "application/smil");
        Utils.setSuffix("sgml", "text/sgml");
        Utils.setSuffix("sgm", "text/sgml");
        Utils.setSuffix("svg", "image/svg+xml");
        Utils.setCharset("ar", "ISO-8859-6");
        Utils.setCharset("be", "ISO-8859-5");
        Utils.setCharset("bg", "ISO-8859-5");
        Utils.setCharset("ca", "ISO-8859-1");
        Utils.setCharset("cs", "ISO-8859-2");
        Utils.setCharset("da", "ISO-8859-1");
        Utils.setCharset("de", "ISO-8859-1");
        Utils.setCharset("el", "ISO-8859-7");
        Utils.setCharset("en", "ISO-8859-1");
        Utils.setCharset("es", "ISO-8859-1");
        Utils.setCharset("et", "ISO-8859-1");
        Utils.setCharset("fi", "ISO-8859-1");
        Utils.setCharset("fr", "ISO-8859-1");
        Utils.setCharset("hr", "ISO-8859-2");
        Utils.setCharset("hu", "ISO-8859-2");
        Utils.setCharset("is", "ISO-8859-1");
        Utils.setCharset("it", "ISO-8859-1");
        Utils.setCharset("iw", "ISO-8859-8");
        Utils.setCharset("ja", "Shift_JIS");
        Utils.setCharset("ko", "EUC-KR");
        Utils.setCharset("lt", "ISO-8859-2");
        Utils.setCharset("lv", "ISO-8859-2");
        Utils.setCharset("mk", "ISO-8859-5");
        Utils.setCharset("nl", "ISO-8859-1");
        Utils.setCharset("no", "ISO-8859-1");
        Utils.setCharset("pl", "ISO-8859-2");
        Utils.setCharset("pt", "ISO-8859-1");
        Utils.setCharset("ro", "ISO-8859-2");
        Utils.setCharset("ru", "ISO-8859-5");
        Utils.setCharset("sh", "ISO-8859-5");
        Utils.setCharset("sk", "ISO-8859-2");
        Utils.setCharset("sl", "ISO-8859-2");
        Utils.setCharset("sq", "ISO-8859-2");
        Utils.setCharset("sr", "ISO-8859-5");
        Utils.setCharset("sv", "ISO-8859-1");
        Utils.setCharset("tr", "ISO-8859-9");
        Utils.setCharset("uk", "ISO-8859-5");
        Utils.setCharset("zh", "GB2312");
        Utils.setCharset("zh_TW", "Big5");
    }
}

