/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawHttpSessionContext;
import org.w3c.jigsaw.servlet.JigsawServletContext;

public class JigsawHttpSession
implements HttpSession {
    private JigsawHttpSessionContext sc = null;
    private JigsawServletContext servletContext = null;
    private String id = null;
    private long creationTime = -1L;
    private long lastAccessedTime = -1L;
    private boolean isValid = false;
    private boolean isNew = false;
    private Cookie cookie = null;
    private Hashtable values = new Hashtable();
    private int maxidle = -1;

    public String getId() {
        return this.id;
    }

    public HttpSessionContext getSessionContext() {
        return this.sc;
    }

    public Object getAttribute(String string) {
        return this.getValue(string);
    }

    public Enumeration getAttributeNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        return this.values.keys();
    }

    public void setAttribute(String string, Object object) {
        this.putValue(string, object);
    }

    public void removeAttribute(String string) {
        this.removeValue(string);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    protected void setLastAccessedTime() {
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public void invalidate() {
        Enumeration enumeration = this.values.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.removeValue(string);
        }
        this.isValid = false;
        this.sc.removeSession(this.id);
    }

    public Object getValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        return this.values.get(string);
    }

    public void putValue(String string, Object object) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        this.removeValue(string);
        if (object != null) {
            this.values.put(string, object);
            if (object instanceof HttpSessionBindingListener) {
                this.valueBound((HttpSessionBindingListener)object, string);
            }
        }
    }

    public void removeValue(String string) {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        Object v = this.values.get(string);
        if (v != null) {
            this.values.remove(string);
            if (v instanceof HttpSessionBindingListener) {
                this.valueUnbound((HttpSessionBindingListener)v, string);
            }
        }
    }

    protected void valueBound(HttpSessionBindingListener httpSessionBindingListener, String string) {
        httpSessionBindingListener.valueBound(new HttpSessionBindingEvent((HttpSession)this, string));
    }

    protected void valueUnbound(HttpSessionBindingListener httpSessionBindingListener, String string) {
        httpSessionBindingListener.valueUnbound(new HttpSessionBindingEvent((HttpSession)this, string));
    }

    public String[] getValueNames() {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid session");
        }
        String[] stringArray = new String[this.values.size()];
        Enumeration enumeration = this.values.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void setNoMoreNew() {
        this.isNew = false;
    }

    protected boolean isValid() {
        return this.isValid;
    }

    protected Cookie getCookie() {
        return this.cookie;
    }

    public void setMaxInactiveInterval(int n) {
        this.maxidle = n;
    }

    public int getMaxInactiveInterval() {
        return this.maxidle;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public JigsawHttpSession(JigsawHttpSessionContext jigsawHttpSessionContext, JigsawServletContext jigsawServletContext, Cookie cookie) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.sc = jigsawHttpSessionContext;
        this.id = jigsawHttpSessionContext.addSession(this);
        this.cookie = cookie;
        this.servletContext = jigsawServletContext;
        cookie.setValue(this.id);
        this.isValid = true;
        this.isNew = true;
    }
}

