/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.IOException;
import org.w3c.jigsaw.filters.SimpleCache;
import org.w3c.jigsaw.filters.SimpleCacheEntry;
import org.w3c.jigsaw.filters.SimpleCacheException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.FilterInterface;
import org.w3c.tools.resources.IntegerAttribute;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.SimpleAttribute;
import org.w3c.www.http.HttpMessage;

public class SimpleCacheFilter
extends ResourceFilter {
    static final boolean debug = true;
    protected SimpleCache cache = null;
    protected static final String STATE_TAG = "org.w3c.jigsaw.filter.SimpleCacheFilter.tag";
    protected static int ATTR_MAX_SIZE = -1;
    protected static int ATTR_MAX_ENTRIES = -1;
    protected static int ATTR_DEFAULT_MAX_AGE = -1;
    protected static int ATTR_FLUSH = -1;

    public int getMaxSize() {
        return this.getInt(ATTR_MAX_SIZE, 8192);
    }

    public int getMaxEntries() {
        return this.getInt(ATTR_MAX_ENTRIES, -1);
    }

    public int getDefaultMaxAge() {
        return this.getInt(ATTR_DEFAULT_MAX_AGE, 300);
    }

    public boolean getFlushFlag() {
        return this.getBoolean(ATTR_DEFAULT_MAX_AGE, false);
    }

    private final void tag(Request request) {
        request.setState(STATE_TAG, Boolean.TRUE);
    }

    private final boolean isTagged(Request request) {
        return request.hasState(STATE_TAG);
    }

    private Reply applyIn(Request request, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Reply reply = null;
        for (int i = n + 1; i < filterInterfaceArray.length && filterInterfaceArray[i] != null; ++i) {
            reply = (Reply)filterInterfaceArray[i].ingoingFilter(request, filterInterfaceArray, i);
            if (reply == null) continue;
            return reply;
        }
        return null;
    }

    private Reply applyOut(Request request, Reply reply, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Reply reply2 = null;
        for (int i = n - 1; i >= 0 && filterInterfaceArray[i] != null; --i) {
            reply2 = (Reply)filterInterfaceArray[i].outgoingFilter(request, reply, filterInterfaceArray, i);
            if (reply2 == null) continue;
            return reply2;
        }
        return null;
    }

    private Reply applyOutSkip(Request request, Reply reply, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Reply reply2 = null;
        for (int i = filterInterfaceArray.length - 1; i >= 0 && i != n && filterInterfaceArray[i] != null; --i) {
            reply2 = (Reply)filterInterfaceArray[i].outgoingFilter(request, reply, filterInterfaceArray, i);
            if (reply2 == null) continue;
            return reply2;
        }
        return null;
    }

    public ReplyInterface ingoingFilter(RequestInterface requestInterface, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        SimpleCacheEntry simpleCacheEntry;
        Request request = (Request)requestInterface;
        String string = request.getMethod();
        if (!string.equals("GET")) {
            return null;
        }
        this.tag(request);
        if (this.isCachable(request) && (simpleCacheEntry = this.cache.retrieve(request)) != null) {
            Reply reply = null;
            reply = this.applyIn(request, filterInterfaceArray, n);
            if (reply != null) {
                return reply;
            }
            Reply reply2 = request.makeReply(1000);
            reply = this.applyOutSkip(request, reply2, filterInterfaceArray, n);
            if (reply != null) {
                return reply;
            }
            try {
                simpleCacheEntry.dump(request.getClient().getOutputStream());
            }
            catch (IOException iOException) {
                return null;
            }
            return reply2;
        }
        return null;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface, FilterInterface[] filterInterfaceArray, int n) throws ProtocolException {
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        if (!this.isTagged(request)) {
            return null;
        }
        if (this.isCachable(reply)) {
            switch (reply.getStatus()) {
                case 200: 
                case 204: 
                case 300: 
                case 301: {
                    try {
                        SimpleCacheEntry simpleCacheEntry = this.cache.store(request, reply);
                        if (simpleCacheEntry != null) {
                            Reply reply2 = this.applyOut(request, reply, filterInterfaceArray, n);
                            if (reply2 != null) {
                                return reply2;
                            }
                            return reply;
                        }
                        break;
                    }
                    catch (SimpleCacheException simpleCacheException) {
                        this.cache.remove(request);
                        break;
                    }
                }
                default: {
                    this.cache.remove(request);
                    break;
                }
            }
        } else {
            this.cache.remove(request);
        }
        return null;
    }

    private boolean isCachable(HttpMessage httpMessage) {
        if (httpMessage.getCacheControl() != null) {
            return false;
        }
        String[] stringArray = httpMessage.getPragma();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals("no-cache")) continue;
                return false;
            }
        }
        return true;
    }

    public void initialize(Object[] objectArray) {
        super.initialize(objectArray);
        this.cache = new SimpleCache(this);
    }

    static {
        SimpleAttribute simpleAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.SimpleCacheFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        simpleAttribute = new IntegerAttribute("maxSize", new Integer(8192), 2);
        ATTR_MAX_SIZE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("maxEntries", new Integer(-1), 2);
        ATTR_MAX_ENTRIES = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new IntegerAttribute("defaultMaxAge", new Integer(300), 2);
        ATTR_DEFAULT_MAX_AGE = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
        simpleAttribute = new BooleanAttribute("flush", Boolean.FALSE, 2);
        ATTR_FLUSH = AttributeRegistry.registerAttribute(clazz, simpleAttribute);
    }
}

