#! /usr/bin/python
# embedfont_plugin.py, version 1.0
# Embeds custom fonts into a ePub
# based on the information from fiery@mobileread
# http://www.mobileread.com/forums/showthread.php?t=61587
# Author: Paul Tomashevskyi with some code from Paul Durrant's fontencrypt.py script
# License: GPL v3
# Revision history:
# 1.0 - Initial release


import sys
import shutil
import zlib
import binascii
import xml.etree.ElementTree as etree
import zipfile
from zipfile import ZipFile, ZipInfo, ZIP_STORED, ZIP_DEFLATED
from contextlib import closing
import os, re
import os.path
from calibre.customize import FileTypePlugin



class EmbedFontPlugin(FileTypePlugin):

 name                = 'EPUB Font embedding plugin' # Name of the plugin
 description         = 'This plugin perform embedding of custom fonts into epub files'
 supported_platforms = ['windows', 'osx', 'linux'] # Platforms this plugin will run on
 author              = 'Art Shim derived work from Paul Tomashevskyi' # The author of this plugin
 version             = (1, 0, 0010)   # The version number of this plugin
 file_types          = set(['epub']) 
 on_postprocess      = True
 output_encoding     = 'UTF-8'
 priority = 100
  
 def run(self, path_to_ebook):

  with closing(ZipFile(open(path_to_ebook, 'rb'))) as inf:
    namelist = set(inf.namelist())
    if 'content.opf' not in namelist:
       print "Error: content.opf missing."
       sys.exit(0)
    content = etree.fromstring(inf.read('content.opf'))
    manifest = content.find("{http://www.idpf.org/2007/opf}manifest")
    if manifest==None:
       print "Error: manifest in content.xml missing"
       sys.exit(0)
	   
    ss = inf.read('stylesheet.css')   
    s = ss.find('font-family:')
    e = ss.find('\n', s)
    fontFamilyName = ss[s:e].replace("font-family: \"","").replace("\";","");
  
    fontName = fontFamilyName.lower()
    fontName = fontName.replace("serif","").replace("sans","").replace("mono","")
  
    fontRegularName = fontFamilyName + '-Regular.ttf'
    fontItalicName = fontFamilyName + '-Italic.ttf'
    fontBoldName = fontFamilyName + '-Bold.ttf'
    fontBoldItalicName = fontFamilyName + '-BoldItalic.ttf'

    fontPath = None

    if fontPath == None:
     for path in sys.path:
	  fontPath = path + "\\..\\resources\\fonts\\" + fontName + "\\"
	  if not os.path.isfile(fontPath + fontItalicName):
		fontPath = None
		continue
	  if not os.path.isfile(fontPath + fontRegularName):
		fontPath = None
		continue
	  if not os.path.isfile(fontPath + fontBoldItalicName):
		fontPath = None
		continue
	  if not os.path.isfile(fontPath + fontBoldName):
		fontPath = None
		continue
	  break

    if fontPath == None:
       print "Error: Cannot find resources"
       print fontFamilyName
       print fontPath
       sys.exit(0)	

# modify manifest file
    manifestitems = manifest.getchildren()
    id1 = etree.SubElement(manifest, 'item')
    id1.attrib["href"]=fontRegularName
    id1.attrib["media-type"]="application/octet-stream"
    id1.attrib["id"]="id1"
    id2 = etree.SubElement(manifest, 'item')
    id2.attrib["href"]=fontItalicName 
    id2.attrib["media-type"]="application/octet-stream"
    id2.attrib["id"]="id2"
    id3 = etree.SubElement(manifest, 'item')
    id3.attrib["href"]=fontBoldItalicName
    id3.attrib["media-type"]="application/octet-stream"
    id3.attrib["id"]="id3"
    id4 = etree.SubElement(manifest, 'item')
    id4.attrib["href"]=fontBoldName
    id4.attrib["media-type"]="application/octet-stream"
    id4.attrib["id"]="id4"
#modify stylesheet.css file
    stylesheetcontent = inf.read('stylesheet.css')
    insertplace = stylesheetcontent.find('.calibre {') 
    newstylesheetcontent = stylesheetcontent[:insertplace]+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyName +"', serif, sans-serif;font-weight: normal;src: url(" + fontItalicName + ");}\n"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyName +"', serif, sans-serif;font-weight: normal;src: url(" + fontRegularName + ");}\n"+\
	"@font-face {font-style: italic;font-family: '" + fontFamilyName +"', serif, sans-serif;font-weight: bold;src: url(" + fontBoldItalicName + ");}\n"+\
	"@font-face {font-style: normal;font-family: '" + fontFamilyName +"', serif, sans-serif;font-weight: bold;src: url(" + fontBoldName + ");}\n"+\
	stylesheetcontent[insertplace:]

    namelist.remove('content.opf') 
    namelist.remove('stylesheet.css') 
    namelist.remove('mimetype')
    kwds = dict(compression=ZIP_DEFLATED, allowZip64=False)
# create the modified archive
    outfile = self.temporary_file("_fe_plugin.epub")
    with closing(ZipFile(outfile, 'w', **kwds)) as outf:
	# output mimetype uncompressed and first
        zi = inf.getinfo('mimetype')
        zi.compress_type = ZIP_STORED
        outf.writestr(zi, inf.read('mimetype'))
	# then write other files
	outf.writestr('content.opf', etree.tostring(content))
	outf.writestr('stylesheet.css', newstylesheetcontent)
	outf.write(fontPath + fontRegularName, fontRegularName)
	outf.write(fontPath + fontItalicName, fontItalicName)
	outf.write(fontPath + fontBoldItalicName, fontBoldItalicName)
	outf.write(fontPath + fontBoldName, fontBoldName)

        for path in namelist:
            data = inf.read(path)
            outf.writestr(path,  data) 

# workaround for calibre bug
# copy the modified file in the place of original ebook
    shutil.copyfile(outfile.name, path_to_ebook)
    return path_to_ebook