class AdvancedUserRecipe1289709253(BasicNewsRecipe):
    title          = u'Macleans Magazine'
    oldest_article = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    no_stylesheets = True

    remove_javascript     = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    remove_tags_before = dict(id='')
    remove_tags = [dict(name='div', attrs={'class':['wp-caption','author','wp-caption aligncenter']}),
                   dict(name='div', attrs={'id':['headerimg','footer']}),
	dict(name='p', attrs={'class':'postmetadata'}),
                   dict(name='img'),
                   dict(name='small'),
]

    feeds          = [(u'Canada', u'http://www2.macleans.ca/category/canada/feed/'),
                          (u'World', u'http://www2.macleans.ca/category/world-from-the-magazine/feed/'), 
                          (u'Arts and Culture', u'http://www2.macleans.ca/category/arts-culture/feed/'), 
                          (u'Opinion', u'http://www2.macleans.ca/category/opinion/feed/'),
                          (u'Health', u'http://www2.macleans.ca/category/health-from-the-magazine/feed/'), 
                          (u'Enviroment', u'http://www2.macleans.ca/category/environment-from-the-magazine/feed/'), 
                          (u'Blog Central', u'http://www2.macleans.ca/category/blog-central/feed/'),
                          
                          ]
						  
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup


    def print_version(self, url):
        return url + "print/"
