----------------------------------------------------------------------
-- poweroff: shutdown the iliad
--
-- Copyright (C) 2009  Iñigo Serna <inigoserna@gmail.com>
-- Time-stamp: <2009-11-22 21:44:44 inigo>


require("os")


----------------------------------------------------------------------
--  window
local win = gtk.Window.new()
win:set("title", "Power-off Iliad", "border-width", 20)
win:connect("delete-event", gtk.main_quit)
local vbox = gtk.VBox.new(false, 20)

-- header: title and quit button
local hbox = gtk.HBox.new(false, 10)
local evbox = gtk.EventBox.new()
evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
local title = gtk.Label.new()
title:set_markup("<span size='xx-large' color='white' weight='bold'>System Operations</span>")
evbox:add(title)
hbox:pack_start(evbox, true, true, 0)
local btn_quit = gtk.Button.new()
local img = gtk.Image.new_from_file("data/quit.png")
btn_quit:connect("clicked", function () win:hide(); win:destroy() end)
btn_quit:add(img)
hbox:pack_end(btn_quit, false, false, 0)

-- question
local text = gtk.Label.new()
text:set_markup("<span size='x-large' weight='bold'>Please select the action or cancel to back</span>")

-- contents
local hbox1 = gtk.HBox.new(false, 0)
local img_off = gtk.Image.new_from_file("data/sysopts-icon.png")
hbox1:pack_start(img_off, true, true, 0)
local vbox2 = gtk.VBox.new(true, 10)
--    shutdown
local btn = gtk.Button.new()
btn:connect("clicked", function()
                          win:hide(); win:destroy()
                          os.execute("/sbin/shutdown -h -P now")
                       end)
local hbox2 = gtk.HBox.new(false, 5)
local img = gtk.Image.new_from_file("data/sysopts-poweroff.png")
hbox2:pack_start(img, false, false, 0)
local lbl = gtk.Label.new("Power-off")
hbox2:pack_start(lbl, true, true, 5)
btn:add(hbox2)
vbox2:pack_start(btn, false, false, 0)
--    reboot
local btn = gtk.Button.new()
btn:connect("clicked", function()
                          win:hide(); win:destroy()
                          os.execute("/sbin/reboot")
                       end)
local hbox2 = gtk.HBox.new(false, 5)
local img = gtk.Image.new_from_file("data/sysopts-reboot.png")
hbox2:pack_start(img, false, false, 0)
local lbl = gtk.Label.new("Reboot")
hbox2:pack_start(lbl, true, true, 5)
btn:add(hbox2)
vbox2:pack_start(btn, false, false, 0)
--    cancel
local btn = gtk.Button.new()
btn:connect("clicked", function() win:hide(); win:destroy() end)
local hbox2 = gtk.HBox.new(false, 5)
local img = gtk.Image.new_from_file("data/sysopts-cancel.png")
hbox2:pack_start(img, false, false, 0)
local lbl = gtk.Label.new("Cancel")
hbox2:pack_start(lbl, true, true, 5)
btn:add(hbox2)
vbox2:pack_start(btn, false, false, 0)
hbox1:pack_start(vbox2, true, false, 50)

-- footer
local img = gtk.Image.new_from_file("data/bar.png")

-- widgets packaging
vbox:pack_start(hbox, false, false, 10)
vbox:pack_start(text, false, false, 10)
vbox:pack_start(hbox1, false, false, 10)
vbox:pack_start(gtk.Label.new(" "), true, true, 10)
vbox:pack_start(img, false, false, 10)
win:add(vbox)

-- show window
win:fullscreen()
win:show_all()


----------------------------------------------------------------------
