require "orbit"

module("util",package.seeall)

function wrap (inner)
    return html{ head(), body(inner) }
end

function htable (rows)
    local res = {}
    for i,row in ipairs(rows) do
        local hrow = {}
        for j,val in ipairs(row) do
            hrow[j] = td(val)
        end
        res[i] = tr(hrow)
    end
    return H'table'(res)
end

function hinput (type,value,name)
    return input{type=type,value=value,name=name}
end

function text (lbl,name,value)
    return label{['for']=name,lbl},hinput('text',value,name)
end

function submit (value)
    return hinput('submit',value,'submit')
end

function import()
    local env = getfenv(2)
    for k,v in pairs(_M) do
        env[k] = v
    end
end

orbit.htmlify (_M,'.+')


