-- ORM1.lua
require "orbit"
require "luasql.sqlite3"
local env = luasql.sqlite3()

function dump (t)
    if #t > 0 then
        for _,row in ipairs(t) do
            dump(row)
        end
    else
        for field,value in pairs(t) do
            if type(value) == 'string' then
                value = value:sub(1,60)
            end
            print(field,type(value),value)
        end
        print '-----'
    end
end

mapper = orbit.model.new()
mapper.conn = env:connect("../blog/blog.db")
mapper.driver = "sqlite3"
mapper.table_prefix = 'blog_'

posts = mapper:new 'post'  -- maps to blog_post table

-- print out the second post
second = posts:find(2)

dump(second)
