#! /usr/bin/env lua

require('luaplot.pieplot')
require('luaplot.svghandler')

-- Example of pie plot.
local plot = luaplot.pieplot.new{
	data            = {20, 30, 15, 10, 25},
	series_colors   = {{1,0.3,0.3}, {0.3,1,0.3}, {0.3,0.3,1}, {0.5,0.5,0.2}, {0.8,0.1,0.7}},
	v_labels        = {"20%", "30%", "15%", "10%", "25%"},
	label_size      = 14,
	width           = 400,
	height          = 400,
	label_scale     = true,
	handler         = luaplot.svghandler.new('out-pieplot.svg'),
}

plot.bg_pattern = cairo.Pattern.create_linear(0, 0, plot.width, plot.height)
plot.bg_pattern:add_color_stop_rgb(0, 1, 1, 1)
plot.bg_pattern:add_color_stop_rgb(1, 0.8, 0.8, 0.9)

plot:render()
