#!/usr/bin/lua

require("DBus")

--foo = DBus.Message.new("net.sf.gaim.GaimService",
--                       "/net/sf/gaim/GaimObject",
--                       "net.sf.gaim.GaimInterface",
--                       "member_function")
foo = DBus.Message("net.sf.gaim.GaimService",
                   "/net/sf/gaim/GaimObject",
                   "net.sf.gaim.GaimInterface",
                   "member_function")

print("signature 1", foo.signature)
foo:append_args("test")
print("signature 2", foo.signature)
foo:append_args(5)
print("signature 3", foo.signature)
foo:append_args(10)
print("signature 4", foo.signature)
foo:append_args("test2")
print("signature 5", foo.signature)

print("foo:is_method_call(GaimInterface)", foo:is_method_call("net.sf.gaim.GaimInterface", "member_function"))
print("foo:is_method_call(aimInterface)", foo:is_method_call("net.sf.gaim.aimInterface", "member_function"))
print("foo:is_signal('signal')", foo:is_signal("net.sf.gaim.GaimInterface", "signal"))
print("foo:is_error('error')", foo:is_error("error"))

print(foo:get_args("string"))
print(foo:get_args("number"))
bar,err = foo:get_args()
print(#bar)
print_table(bar)

print("Testing large append of intermixed values")
foo:append_args({"this", "is", "a", "test", "of", "the", "table", "adding", 1, 1, "!"})
bar,err = foo:get_args()
print(#bar)
print_table(bar)
