--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

require('luaplot.basehandler')

luaplot.svghandler = {}
setmetatable(luaplot.svghandler, {__index = luaplot.basehandler})

local svghandlermt = {__index = luaplot.svghandler}
local super = luaplot.basehandler

function luaplot.svghandler.new(filename)
	local self = {}
	setmetatable(self, svghandlermt)
	
	self.filename = filename
	
	return self
end

function luaplot.svghandler:prepare(plot)
	self.surface = cairo.SvgSurface.create(self.filename, plot.width, plot.height)
	plot.cr      = cairo.Context.create(self.surface)
	super.prepare(self, plot)
end

function luaplot.svghandler:commit(plot)
	plot.cr:show_page()
	self.surface:finish()
	super.commit(self, plot)
end
