--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

require('luaplot.plot')

---
-- Bar plotting class.
luaplot.legendplot = {}
setmetatable(luaplot.legendplot, {__index = luaplot.plot})
local legendplotmt = {__index = luaplot.legendplot}

function luaplot.legendplot.new(args)
	local self = luaplot.plot.new(args)
	setmetatable(self, legendplotmt)
	
	return self
end

function luaplot.legendplot:render_plot()
	-- pass, all the work is done in render_labels
end

function luaplot.legendplot:render_labels()
	local step = self.height / (#self.v_labels + 1)
	local cr = self.cr
	
	-- Calculate the size of the color rectangle
	local min = math.min(self.width, self.height) 
	local rect_height = (min / #self.v_labels) / 2
	local rect_width = rect_height * 2
	
	-- Calculate the compensation for the rectangle
	local r_comp = rect_height / 2
	local x, y = self.h_offset + 5, step + self.v_offset
	
	-- Render each label
	for n, label in ipairs(self.v_labels) do
		cr:set_source_rgb(unpack(self.series_colors[n]))
		cr:rectangle(x, y - r_comp, rect_width, rect_height)
		cr:fill_preserve()
		cr:set_source_rgb(unpack(self.line_color))
		cr:stroke()
		
		cr:set_source_rgb(unpack(self.label_color))
		cr:move_to(x + 5 + rect_width, y - (self.v_labels_height[n] / 3) )
		
		self.text_layout:set_text(label, -1)
		pangocairo.show_layout(cr, self.text_layout)
		
		y = y + step
	end
end
