--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

require('luaplot.basehandler')

luaplot.childhandler = {}
setmetatable(luaplot.childhandler, {__index = luaplot.basehandler})

local childhandlermt = {__index = luaplot.childhandler}
local super = luaplot.basehandler

function luaplot.childhandler.new(parent, x, y)
	local self  = {}
	setmetatable(self, childhandlermt)
	
	self.parent = parent
	self.x      = x
	self.y      = y
	
	return self
end

function luaplot.childhandler:prepare(plot)
	plot.cr         = self.parent.cr
	plot.h_offset   = self.x
	plot.v_offset   = self.y
	super.prepare(self, plot)
end

function luaplot.childhandler:commit(plot)
end
