--[[
	This file is part of luaplot.

	luaplot is free software: you can redistribute it and/or modify
	it under the terms of the GNU Lesser General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	luaplot is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public License
	along with luaplot.  If not, see <http://www.gnu.org/licenses/>.
    
    Copyright (C) 2009-2010 Lucas Hermann Negri
--]]

require('luaplot.plot')

luaplot.basehandler = {}
local basehandlermt = {__index = luaplot.basehandler}

function luaplot.basehandler.new(filename)
	local self = {}
	setmetatable(self, basehandlermt)
	
	return self
end

function luaplot.basehandler:prepare(plot)
	plot.text_layout    = pangocairo.create_layout(plot.cr)
	plot.font_desc      = pango.FontDescription.from_string(plot.label_font)
end

function luaplot.basehandler:commit(plot)
	plot.cr:destroy()
	self.surface:destroy()
end
