#!/media/mmcblk0p1/Programs/_lua/bin/lua

----------------------------------------------------------------------
-- gui-icons.lua: GUI for icons.lua
--
-- Copyright (C) 2010  Iñigo Serna <inigoserna@gmail.com>
-- Released under GPL v3+
--
-- Time-stamp: <2010-12-14 01:10:13 inigo>
----------------------------------------------------------------------


require("lgob.gtk")
require("lgob.gdk")


----------------------------------------------------------------------
----- Constants
local LUADIR = "/media/mmcblk0p1/Programs/_lua"
local PROG_ICONS = LUADIR .. "/scripts/icons.lua"
local OUTPUT_PATH = "/media/mmcblk0p1/"
local DEFAULT_STYLE = [[
      style "edit-style" { font_name = "mono 7" }
      class "GtkTextView" style "edit-style"
]]


----------------------------------------------------------------------
----- Global Variables
local cbtnPrograms, cbtnFB2s, btnSave, btnRun, tvOutputBuffer


----------------------------------------------------------------------
----- gtk+ helper functions
local mygtk = {
    -- create a label with markup
    Markup_new = function(txt)
                     local label = gtk.Label.new()
                     label:set_markup(txt)
                     return label
                 end
}


----------------------------------------------------------------------
----- Callbacks
function cb_run(win)
    btnRun:set("sensitive", false)
    tvOutputBuffer:set_text("Please wait while executing", -1)
    -- win:get("window"):set_cursor(gdk.Cursor.new(gdk.WATCH))
    while gtk.events_pending() do
        gtk.main_iteration()
    end
    cmd = PROG_ICONS
    if cbtnPrograms:get_active() then
        cmd = cmd .. " --programs"
    end
    if cbtnFB2s:get_active() then
        cmd = cmd .. " --fb2"
    end
    local f = io.popen(cmd)
    local buf = f:read("*a"):gsub("^%s*(.-)%s*$", "%1")
    f:close()
    if buf ~= "" then
        tvOutputBuffer:set_text(buf, -1)
        btnSave:set("sensitive", true)
    else
        tvOutputBuffer:set_text("-- No output --", -1)
    end
    btnRun:set("sensitive", true)
    -- win:get("window"):set_cursor(gdk.Cursor.new(gdk.LEFT_PTR))
end


function cb_save(win)
    local istart, iend = gtk.TextIter.new(), gtk.TextIter.new()
    tvOutputBuffer:get_bounds(istart, iend)
    local buf = tvOutputBuffer:get_text(istart, iend)
    local fname = OUTPUT_PATH .. 'icons-' .. os.date('%Y%m%d%H%M%S') .. '.log'
    local f = io.open(fname, 'w')
    f:write(buf)
    f:close()
    local dlg = gtk.MessageDialog.new(win, gtk.DIALOG_MODAL, gtk.MESSAGE_INFO,
                                      gtk.BUTTONS_OK, "Output saved")
    dlg:set_markup('<span size="large" weight="bold">Output saved!</span>\n\n' ..
                   'in file <i>"' .. fname .. '"</i>')
    dlg:run()
    dlg:destroy()
    btnSave:set("sensitive", false)
end


----------------------------------------------------------------------
----- UI
function ui_init()
    local win = gtk.Window.new()
    win:set("title", "Generate icons & covers", "border-width", 20)
    win:connect("delete-event", function() gtk.main_quit() end)
    local vbox = gtk.VBox.new(false, 0)

    -- header: title and quit button
    local hbox = gtk.HBox.new(false, 10)
    local evbox = gtk.EventBox.new()
    evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
    local title = mygtk.Markup_new("<span size='xx-large' color='white' weight='bold'>Generate icons &amp; covers</span>")
    evbox:add(title)
    hbox:pack_start(evbox, true, true, 0)
    local evbox_quit = gtk.EventBox.new()
    evbox_quit:set_events(gdk.BUTTON_PRESS_MASK)
    evbox_quit:connect("button-press-event", function() gtk.main_quit() end)
    local img = gtk.Image.new_from_file(LUADIR .. "/share/pixmaps/quit.png")
    evbox_quit:add(img)
    hbox:pack_end(evbox_quit, false, false, 0)
    vbox:pack_start(hbox, false, false, 10)

    -- text
    local label = mygtk.Markup_new("<span size='large'>This program generates images for programs and ebooks.\n\nPlease select the types of images you want to create:</span>")
    label:set_alignment(0, 0.5)
    vbox:pack_start(label, false, false, 10)

    -- checkbuttons
    cbtnPrograms = gtk.CheckButton.new()
    cbtnPrograms:set_label("Icons for Programs")
    cbtnPrograms:set_active(true)
    vbox:pack_start(cbtnPrograms, false, false, 5)
    cbtnFB2s = gtk.CheckButton.new()
    cbtnFB2s:set_label("Covers for FB2 files")
    cbtnFB2s:set_active(true)
    vbox:pack_start(cbtnFB2s, false, false, 5)

    -- hbox: output header and execute button
    local hbox = gtk.HBox.new(false, 75)
    btnRun = gtk.Button.new_from_stock("gtk-execute")
    btnRun:connect("clicked", cb_run, win)
    hbox:pack_start(btnRun, true, true, 0)
    btnSave = gtk.Button.new_from_stock("gtk-save")
    btnSave:set("sensitive", false)
    btnSave:connect("clicked", cb_save, win)
    hbox:pack_start(btnSave, true, true, 0)
    vbox:pack_start(hbox, false, false, 20)

    -- separator
    vbox:pack_start(gtk.HSeparator.new(), false, false, 10)

    -- output
    local expander = gtk.Expander.new("<span size='large' weight='bold'> Show output</span>")
    expander:set_use_markup(true)
    vbox:pack_start(expander, true, true, 0)
    local scrollwin = gtk.ScrolledWindow.new()
    scrollwin:set("hscrollbar-policy", gtk.POLICY_AUTOMATIC,
                  "vscrollbar-policy", gtk.POLICY_AUTOMATIC,
                  "shadow-type", gtk.SHADOW_IN)
    local tvOutput = gtk.TextView.new()
    tvOutput:set("editable", false, "cursor-visible", false,
                 "left-margin", 10, "right-margin", 10)
    tvOutputBuffer = tvOutput:get("buffer")
    tvOutputBuffer:set_text("-- No output --", -1)
    scrollwin:add(tvOutput)
    expander:add(scrollwin)

    -- show window
    win:add(vbox)
    win:fullscreen()
    win:show_all()
end


----------------------------------------------------------------------
----- Main
gtk.rc_parse_string(DEFAULT_STYLE)
ui_init()
gtk.main()
