----------------------------------------------------------------------
-- help: show README file
--
-- Copyright (C) 2009  Iñigo Serna <inigoserna@gmail.com>
-- Time-stamp: <2009-11-22 21:44:39 inigo>


----------------------------------------------------------------------
-- style
local DEFAULT_STYLE = [[
      style "edit-style" { font_name = "mono 7" }
      class "GtkTextView" style "edit-style"
]]
gtk.rc_parse_string(DEFAULT_STYLE)


----------------------------------------------------------------------
-- window
local win = gtk.Window.new()
win:set("title", "Iliad Toolbox Documentation", "border-width", 20)
win:connect("delete-event", gtk.main_quit)

-- header: title and quit button
local hbox = gtk.HBox.new(false, 10)
local evbox = gtk.EventBox.new()
evbox:modify_bg(gtk.STATE_NORMAL, gdk.color_parse("black"))
local title = gtk.Label.new()
title:set_markup("<span size='xx-large' color='white' weight='bold'>Iliad Toolbox Documentation</span>")
evbox:add(title)
hbox:pack_start(evbox, true, true, 0)

local btn_quit = gtk.Button.new()
local img = gtk.Image.new_from_file("data/quit.png")
btn_quit:connect("clicked", function () win:hide(); win:destroy() end)
btn_quit:add(img)
hbox:pack_end(btn_quit, false, false, 0)

-- textview
local f = io.open("readme")
local text = f:read("*a")
f:close()
local scrollwin = gtk.ScrolledWindow.new()
scrollwin:set("hscrollbar-policy", gtk.POLICY_NEVER,
              "vscrollbar-policy", gtk.POLICY_AUTOMATIC)
local tv = gtk.TextView.new()
tv:set("editable", false, "cursor-visible", false,
       "left-margin", 10, "right-margin", 10)
-- tv:set_border_window_width(gtk.Text_WINDOW_LEFT, 100)
scrollwin:add(tv)
local tbuf = tv:get("buffer")
local iter = gtk.TextIter.new()
tbuf:get_end_iter(iter)
tbuf:insert(iter, text, -1)

-- footer
local img = gtk.Image.new_from_file("data/bar.png")

-- widgets packaging
local vbox = gtk.VBox.new(false, 20)
vbox:pack_start(hbox, false, false, 10)
vbox:pack_start(scrollwin, true, true, 10)
vbox:pack_start(img, false, false, 10)
win:add(vbox)

-- show window
win:fullscreen()
win:show_all()


----------------------------------------------------------------------
