-- blog2.lua
require"orbit"

--- managing the model ------
require "luasql.sqlite3"
local env = luasql.sqlite3()

local mapper = orbit.model.new()
mapper.conn = env:connect("../blog/blog.db")
mapper.driver = "sqlite3"
mapper.table_prefix = 'blog_'

local posts = mapper:new 'post'  -- maps to blog_post table

module("blog2", package.seeall, orbit.new)

function index(web)
  local keyword = web.GET.keyword or ''
  if keyword == '' then return {}
  else
    return render_index(posts:find_all('title like ?',{'%'..keyword..'%'}))
  end
end

blog2:dispatch_get(index, "/", "/index")

local function limit (s,maxlen)
	if #s > maxlen then
		return s:sub(1,maxlen)..'...'
	else
		return s
	end
end

function render_page(contents)
	return html {
		head { title 'Blog Example' },
		body (contents)
	}
end

function render_post(post)
	return div {
		h3 (post.id .. ' ' .. post.title),
		p (limit(post.body,128)),
		em(os.date('%a %b %d %H:%M %Y',post.published_at)),
        ' ',post.n_comments,' comments'
	}
end

function render_index(posts)
	local res = {}
	for i,post in ipairs(posts) do
		res[i] = render_post(post)
	end
	return render_page(res)
end

orbit.htmlify(blog2,'render_.+')


