-- basic2.lua
require"orbit"

module("basic2", package.seeall, orbit.new)

function index(web)
  return render_index(collectgarbage("count"))
end

basic2:dispatch_get(index, "/", "/index")
basic2:dispatch_static ("/images/.+")

local template = [[
<head></head>
<html>
%s
</html>
]]

function render_page(contents)
    return template:format(contents)
end

function render_index(mem)
   return ([[
    <img src="/images/lua.png"/>
    <h2>Memory used by Lua is %6.0f kB<h2>
   ]]):format(mem)
end
