#! /usr/bin/env lua

require('luaplot.barplot')
require('luaplot.pnghandler')

-- Simple example of how to render a bar plot to a PNG file.
local plot = luaplot.barplot.new{
	data 			= { {20, 10, 30}, {5, 30, 10} },
	h_labels		= {"Group 1", "Group 2"},
	v_labels		= {'0', '5', '10', '15', '20', '25', '30'},
	series_colors 	= {{1,0.3,0.3}, {0.3,1,0.3}, {0.0, 0.3, 1}},
	handler 		= luaplot.pnghandler.new('out-simple.png'),
}

-- Render it
plot:render()
