#! /usr/bin/env lua

require('luaplot.legendplot')
require('luaplot.pieplot')
require('luaplot.gtkhandler')
require('luaplot.childhandler')
require('lgob.gtk')

local window = gtk.Window.new()
window:set('title', "Plotting in a GtkWindow ", 'window-position', gtk.WIN_POS_CENTER,
	'app-paintable', true, 'width-request', 400, 'height-request', 400)

-- Pie plot.
local plot = luaplot.pieplot.new{
	data            = {20, 10, 15, 30, 25},
	series_colors   = {{1,0.3,0.3}, {0.3,1,0.3}, {0.3,0.3,1}, {0.5,0.5,0.2}, {0.8,0.1,0.7}},
	v_labels        = {"20%", "10%", "15%", "30%", "25%"},
	label_size      = 10,
	label_scale     = true,
	handler         = luaplot.gtkhandler.new(window),
	bg_color        = {0.1,0.2,0.5, 1},
	right_margin    = 75
}

-- Legend.
local legend = luaplot.legendplot.new{
	v_labels        = {'C', 'C++', 'Java', 'Lua', 'PHP'},
	series_colors   = plot.series_colors,
	label_color     = plot.label_color,
	label_size      = 24,
	label_scale     = true,
	width           = 100,
	height          = 100,
	handler         = luaplot.childhandler.new(plot, 300, 000),
	pre_callback = function(self)
		-- recalculate the size of the legend
		self.width  = plot.width / 4
		self.height = plot.width / 4
		
		-- recalculate the position of the legend
		self.handler.x = plot.width - self.width
	end
}

plot.child = {legend}

window:show_all()
window:connect('delete-event', gtk.main_quit)
window:connect('expose-event', plot.handler.expose, plot)
window:connect('size-allocate', window.queue_draw, window, true)

gtk.main()
